/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.integration.orgdb.model;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.glite.security.voms.admin.integration.orgdb.model.Country;
import org.glite.security.voms.admin.integration.orgdb.model.InstituteAddress;
import org.hibernate.annotations.Immutable;

@Entity
@Immutable
@Table(name="INSTITUTES")
public class Institute
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="CODE", length=6)
    String code;
    @Column(name="ENGLISH_NAME", length=71)
    String englishName;
    @Column(name="ORIGINAL_NAME", length=71)
    String originalName;
    @Column(name="NAME", length=71)
    String name;
    @ManyToOne(optional=true)
    @JoinColumn(name="PARENT_INSTITUTE")
    Institute parent;
    @ManyToOne(optional=true)
    @JoinColumn(name="ADDRESS_ID")
    InstituteAddress address;
    @Column(name="INSTITUTE_TYPE", length=2)
    String type;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="COUNTRY_CODE")
    Country country;
    @Column(name="PLACE", length=30, nullable=false)
    String place;
    @Column(name="URL", length=100)
    String url;
    @Column(name="STATUS", length=1, nullable=false)
    String status;
    @Column(name="LIBRARY", length=1, nullable=false)
    String library;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public void setEnglishName(String englishName) {
        this.englishName = englishName;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Institute getParent() {
        return this.parent;
    }

    public void setParent(Institute parent) {
        this.parent = parent;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getLibrary() {
        return this.library;
    }

    public void setLibrary(String library) {
        this.library = library;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
        result = 31 * result + (this.englishName == null ? 0 : this.englishName.hashCode());
        result = 31 * result + (this.library == null ? 0 : this.library.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.originalName == null ? 0 : this.originalName.hashCode());
        result = 31 * result + (this.place == null ? 0 : this.place.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Institute other = (Institute)obj;
        if (this.country == null ? other.country != null : !this.country.equals(other.country)) {
            return false;
        }
        if (this.englishName == null ? other.englishName != null : !this.englishName.equals(other.englishName)) {
            return false;
        }
        if (this.library == null ? other.library != null : !this.library.equals(other.library)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.originalName == null ? other.originalName != null : !this.originalName.equals(other.originalName)) {
            return false;
        }
        if (this.place == null ? other.place != null : !this.place.equals(other.place)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Institute [code=").append(this.code).append(", name=").append(this.name).append(", englishName=").append(this.englishName).append(", originalName=").append(this.originalName).append("]");
        return builder.toString();
    }
}

