/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.integration.orgdb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.core.tasks.VOMSExecutorService;
import org.glite.security.voms.admin.core.validation.ValidationManager;
import org.glite.security.voms.admin.integration.AbstractPluginConfigurator;
import org.glite.security.voms.admin.integration.VOMSPluginConfigurationException;
import org.glite.security.voms.admin.integration.orgdb.DefaultSyncStrategy;
import org.glite.security.voms.admin.integration.orgdb.LogOnlyExpiredParticipationStrategy;
import org.glite.security.voms.admin.integration.orgdb.OrgDBMembershipSynchronizationTask;
import org.glite.security.voms.admin.integration.orgdb.OrgDBRequestValidator;
import org.glite.security.voms.admin.integration.orgdb.SuspendInvalidMembersStrategy;
import org.glite.security.voms.admin.integration.orgdb.dao.OrgDBDAOFactory;
import org.glite.security.voms.admin.integration.orgdb.dao.OrgDBVOMSPersonDAO;
import org.glite.security.voms.admin.integration.orgdb.database.OrgDBError;
import org.glite.security.voms.admin.integration.orgdb.database.OrgDBSessionFactory;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgDBConfigurator
extends AbstractPluginConfigurator {
    public static final Logger log = LoggerFactory.getLogger(OrgDBConfigurator.class);
    public static final String DEFAULT_CONFIG_FILE_NAME = "orgdb.properties";
    public static final String ORGDB_EXPERIMENT_NAME_PROPERTY = "experimentName";
    public static final String ORGDB_MEMBERSHIP_CHECK_PERIOD_IN_SECONDS = "membership_check.period";
    public static final String ORGDB_REGISTRATION_TYPE = "orgdb";
    private static final Long ORGDB_DEFAULT_CHECK_PERIOD = 26100L;

    Properties loadOrgDBDatabaseProperties() throws VOMSPluginConfigurationException {
        String defaultConfigFilePath = this.getVomsConfigurationDirectoryPath() + "/" + DEFAULT_CONFIG_FILE_NAME;
        String configFilePath = this.getPluginProperty("configFile", defaultConfigFilePath);
        Properties orgDbProps = new Properties();
        try {
            orgDbProps.load(new FileInputStream(new File(configFilePath)));
        }
        catch (FileNotFoundException e) {
            String errorMessage = String.format("Configuration file '%s' for plugin '%s' does not exist!", configFilePath, this.getPluginName());
            throw new VOMSPluginConfigurationException(errorMessage, e);
        }
        catch (IOException e) {
            String errorMessage = String.format("Error reading configuration file '%s' for plugin '%s' does not exist!", configFilePath, this.getPluginName());
            throw new VOMSPluginConfigurationException(errorMessage, e);
        }
        return orgDbProps;
    }

    public void checkOrgDBConnection() {
        log.debug("Running OrgDB connection check.");
        OrgDBVOMSPersonDAO personDAO = OrgDBDAOFactory.instance().getVOMSPersonDAO();
        try {
            personDAO.findPersonByEmail("andrea.ceccanti@cnaf.infn.it");
            log.info("Connection to the OrgDB database is active.");
        }
        catch (HibernateException e) {
            log.warn("Error contacting the OrgDB database.");
        }
    }

    @Override
    public void configure() throws VOMSPluginConfigurationException {
        Long checkPeriod;
        log.debug("OrgDB voms configuration started.");
        try {
            OrgDBSessionFactory.initialize(this.loadOrgDBDatabaseProperties());
        }
        catch (OrgDBError e) {
            log.error("Error configuring OrgDB hibernate session factory!", (Throwable)e);
            throw new VOMSPluginConfigurationException("Error initalizing OrgDB hibernate session factory!", e);
        }
        log.debug("OrgDB Database properties loaded succesfully.");
        this.checkOrgDBConnection();
        String uppercaseVOName = VOMSConfiguration.instance().getVOName().toUpperCase();
        String experimentName = this.getPluginProperty(ORGDB_EXPERIMENT_NAME_PROPERTY, uppercaseVOName);
        log.info("Setting OrgDB experiment name: {}", (Object)experimentName);
        OrgDBRequestValidator validator = new OrgDBRequestValidator(experimentName);
        ValidationManager.instance().setRequestValidationContext(validator);
        VOMSConfiguration.instance().setRegistrationType(ORGDB_REGISTRATION_TYPE);
        VOMSConfiguration.instance().setProperty("___voms.read-only-personal-information", Boolean.TRUE);
        VOMSConfiguration.instance().setProperty("___voms.read-only-membership-expiration", Boolean.TRUE);
        log.info("OrgDB request validator registered SUCCESSFULLY.");
        try {
            checkPeriod = Long.parseLong(this.getPluginProperty(ORGDB_MEMBERSHIP_CHECK_PERIOD_IN_SECONDS, ORGDB_DEFAULT_CHECK_PERIOD.toString()));
        }
        catch (NumberFormatException e) {
            log.error("Error parsing OrgDB membership check validity period: {}. Please provide an appropriate number for the OrgDb membership_check.period property!", (Object)e.getMessage());
            log.error("The default value of {} seconds will be used instead.", (Object)ORGDB_DEFAULT_CHECK_PERIOD);
            checkPeriod = ORGDB_DEFAULT_CHECK_PERIOD;
        }
        OrgDBMembershipSynchronizationTask syncTask = new OrgDBMembershipSynchronizationTask(experimentName, new SuspendInvalidMembersStrategy(), new LogOnlyExpiredParticipationStrategy(), new DefaultSyncStrategy());
        VOMSExecutorService.instance().startBackgroundTask(syncTask, null, checkPeriod);
    }
}

