/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.integration.orgdb;

import java.util.Calendar;
import java.util.Date;
import org.glite.security.voms.admin.integration.orgdb.model.Participation;
import org.glite.security.voms.admin.integration.orgdb.model.VOMSOrgDBPerson;
import org.glite.security.voms.admin.integration.orgdb.strategies.OrgDBMembershipSynchronizationStrategy;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSyncStrategy
implements OrgDBMembershipSynchronizationStrategy {
    public static final Logger log = LoggerFactory.getLogger(DefaultSyncStrategy.class);

    protected void synchronizeMembershipExpirationDate(VOMSUser u, VOMSOrgDBPerson orgDbPerson, String experimentName) {
        if (orgDbPerson.hasValidParticipationForExperiment(experimentName)) {
            Participation p = orgDbPerson.getValidParticipationForExperiment(experimentName);
            if (p.getEndDate() != null) {
                log.debug("Setting {} expiration date to {}. Previous value was: {}", new Object[]{u, p.getEndDate(), u.getEndTime()});
                u.setEndTime(p.getEndDate());
            } else {
                Calendar cal = Calendar.getInstance();
                cal.add(7, 5);
                Date fiveDaysFromNow = cal.getTime();
                if (u.getEndTime().compareTo(fiveDaysFromNow) < 0) {
                    log.debug("User VOMS memership end time: {}", (Object)u.getEndTime());
                    log.debug("User {} membership is going to expire within 5 days, but user has a valid OrgDB experiment participation.", (Object)u);
                    cal.setTime(u.getEndTime());
                    cal.add(1, 1);
                    u.setEndTime(cal.getTime());
                    log.debug("New VOMS membership expiration date: {}. Note that this is purely indicative and will be anyway kept consistent with what comes from the OrgDb.", (Object)u.getEndTime());
                }
            }
        } else {
            Participation expiredParticipation = orgDbPerson.getLastExpiredParticipationForExperiment(experimentName);
            Date now = new Date();
            if (expiredParticipation == null) {
                if (!u.hasExpired()) {
                    log.debug("Expiring VOMS membership for user {} since no valid or expired OrgDB participation was found for experiment {}", (Object)u, (Object)experimentName);
                    u.setEndTime(now);
                }
            } else if (u.getEndTime().after(expiredParticipation.getEndDate())) {
                log.debug("Setting {} expiration date to {}. Previous value was: {}", new Object[]{u, expiredParticipation.getEndDate(), u.getEndTime()});
                u.setEndTime(expiredParticipation.getEndDate());
            }
        }
    }

    protected void synchronizeMembershipInstitutionInfo(VOMSUser u, VOMSOrgDBPerson orgDbPerson, String experimentName) {
        if (orgDbPerson.hasValidParticipationForExperiment(experimentName)) {
            Participation p = orgDbPerson.getValidParticipationForExperiment(experimentName);
            if (!u.getInstitution().equals(p.getInstitute().getOriginalName())) {
                log.debug("Institution for user {} and participation {} do not match. Updating VOMS institution field.", (Object)u, (Object)p);
                u.setInstitution(p.getInstitute().getOriginalName());
            }
        }
    }

    @Override
    public void synchronizeMemberInformation(VOMSUser u, VOMSOrgDBPerson orgDbPerson, String experimentName) {
        log.debug("Synchronizing pariticipation data for user {} against orgdb record {} for experiment {}", new Object[]{u, orgDbPerson, experimentName});
        this.synchronizeMembershipExpirationDate(u, orgDbPerson, experimentName);
        this.synchronizeMembershipInstitutionInfo(u, orgDbPerson, experimentName);
    }
}

