/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.event;

import java.util.ArrayList;
import java.util.List;
import org.glite.security.voms.admin.event.Event;
import org.glite.security.voms.admin.event.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManager {
    public static final Logger log = LoggerFactory.getLogger(EventManager.class);
    final List<EventListener> listeners = new ArrayList<EventListener>();
    private static EventManager instance = null;

    public static final EventManager instance() {
        if (instance == null) {
            instance = new EventManager();
        }
        return instance;
    }

    private EventManager() {
    }

    public void register(EventListener listener) {
        this.listeners.add(listener);
    }

    public void unRegister(EventListener listener) {
        this.listeners.remove(listener);
    }

    public List<EventListener> getListeners() {
        return this.listeners;
    }

    public void fireEvent(Event e) {
        block3: {
            try {
                for (EventListener l : this.getListeners()) {
                    if (l.getMask() != null && !l.getMask().get(e.getType().bitNo)) continue;
                    l.fire(e);
                }
            }
            catch (Throwable t) {
                log.error("Error dispatching event '" + e + "': " + t.getMessage());
                if (!log.isDebugEnabled()) break block3;
                log.error("Error dispatching event '" + e + "': " + t.getMessage(), t);
            }
        }
    }

    public static void dispatch(Event e) {
        if (instance == null) {
            log.debug("Event manager has not been initialized! The event will be lost...");
        } else {
            instance.fireEvent(e);
        }
    }
}

