/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.validation.strategies.impl;

import org.glite.security.voms.admin.core.validation.UserSuspensionManagementContext;
import org.glite.security.voms.admin.core.validation.strategies.RestoreUserStrategy;
import org.glite.security.voms.admin.core.validation.strategies.SuspendUserStrategy;
import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.user.UserRestoredEvent;
import org.glite.security.voms.admin.event.user.UserSuspendedEvent;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserSuspensionManagementBehaviour
implements SuspendUserStrategy,
RestoreUserStrategy,
UserSuspensionManagementContext {
    public static final Logger log = LoggerFactory.getLogger(DefaultUserSuspensionManagementBehaviour.class);

    @Override
    public void suspendUser(VOMSUser user, VOMSUser.SuspensionReason suspensionReason) {
        if (!user.isSuspended()) {
            user.suspend(suspensionReason);
            EventManager.instance().fireEvent(new UserSuspendedEvent(user, suspensionReason));
        }
    }

    @Override
    public void restoreUser(VOMSUser user) {
        if (user.isSuspended()) {
            user.restore();
            EventManager.instance().fireEvent(new UserRestoredEvent(user));
        }
    }

    @Override
    public RestoreUserStrategy getRestoreUserStrategy() {
        return this;
    }

    @Override
    public SuspendUserStrategy getSuspendUserStrategy() {
        return this;
    }
}

