/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.validation;

import org.glite.security.voms.admin.core.tasks.VOMSExecutorService;
import org.glite.security.voms.admin.core.validation.MembershipCheckerTask;
import org.glite.security.voms.admin.core.validation.MembershipValidationContext;
import org.glite.security.voms.admin.core.validation.RequestValidationContext;
import org.glite.security.voms.admin.core.validation.RequestValidationResult;
import org.glite.security.voms.admin.core.validation.UserSuspensionManagementContext;
import org.glite.security.voms.admin.core.validation.strategies.RequestValidationStrategy;
import org.glite.security.voms.admin.core.validation.strategies.RestoreUserStrategy;
import org.glite.security.voms.admin.core.validation.strategies.SuspendUserStrategy;
import org.glite.security.voms.admin.core.validation.strategies.impl.DefaultMembershipCheckBehaviour;
import org.glite.security.voms.admin.core.validation.strategies.impl.DefaultRequestValidationBehaviour;
import org.glite.security.voms.admin.core.validation.strategies.impl.DefaultUserSuspensionManagementBehaviour;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.request.NewVOMembershipRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationManager
implements SuspendUserStrategy,
RestoreUserStrategy,
RequestValidationStrategy<NewVOMembershipRequest> {
    public static Logger log = LoggerFactory.getLogger(ValidationManager.class);
    private static volatile ValidationManager INSTANCE = null;
    protected RequestValidationContext requestValidationContext;
    protected MembershipValidationContext membershipValidationContext = new DefaultMembershipCheckBehaviour();
    protected UserSuspensionManagementContext userSuspensionManagementContext;

    private ValidationManager() {
        this.requestValidationContext = new DefaultRequestValidationBehaviour();
        this.userSuspensionManagementContext = new DefaultUserSuspensionManagementBehaviour();
    }

    public static synchronized ValidationManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new ValidationManager();
        }
        return INSTANCE;
    }

    public void startMembershipChecker() {
        log.debug("Starting membership checker task.");
        MembershipCheckerTask checker = new MembershipCheckerTask(this.membershipValidationContext);
        VOMSExecutorService.instance().startBackgroundTask(checker, "voms.task.membership_check.period", 300L);
        log.debug("Membership validation context: {}", (Object)this.membershipValidationContext);
        log.debug("Request validation context: {}", (Object)this.requestValidationContext);
        log.debug("User suspension management context: {}", (Object)this.userSuspensionManagementContext);
    }

    public RequestValidationContext getRequestValidationContext() {
        return this.requestValidationContext;
    }

    public void setRequestValidationContext(RequestValidationContext requestValidationContext) {
        this.requestValidationContext = requestValidationContext;
    }

    public MembershipValidationContext getMembershipValidationContext() {
        return this.membershipValidationContext;
    }

    public void setMembershipValidationContext(MembershipValidationContext membershipValidationContext) {
        this.membershipValidationContext = membershipValidationContext;
    }

    public UserSuspensionManagementContext getUserSuspensionManagementContext() {
        return this.userSuspensionManagementContext;
    }

    public void setUserSuspensionManagementContext(UserSuspensionManagementContext userSuspensionManagementContext) {
        this.userSuspensionManagementContext = userSuspensionManagementContext;
    }

    @Override
    public void suspendUser(VOMSUser user, VOMSUser.SuspensionReason suspensionReason) {
        this.getUserSuspensionManagementContext().getSuspendUserStrategy().suspendUser(user, suspensionReason);
    }

    @Override
    public void restoreUser(VOMSUser user) {
        this.getUserSuspensionManagementContext().getRestoreUserStrategy().restoreUser(user);
    }

    @Override
    public RequestValidationResult validateRequest(NewVOMembershipRequest r) {
        return this.getRequestValidationContext().getVOMembershipRequestValidationStrategy().validateRequest(r);
    }
}

