/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.validation;

import java.util.List;
import org.glite.security.voms.admin.core.tasks.RegistrationServiceTask;
import org.glite.security.voms.admin.core.validation.AbstractMembershipChecker;
import org.glite.security.voms.admin.core.validation.MembershipValidationContext;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MembershipCheckerTask
extends AbstractMembershipChecker
implements Runnable,
RegistrationServiceTask {
    public static final Logger log = LoggerFactory.getLogger(MembershipCheckerTask.class);

    public MembershipCheckerTask(MembershipValidationContext ctxt) {
        this.setValidationContext(ctxt);
    }

    @Override
    public void checkMembershipStatus() {
        List<VOMSUser> expiringMembers = this.getExpiringMembersLookupStrategy().findExpiringMembers();
        log.debug("Expiring members: {}", expiringMembers);
        this.getHandleExpiringMembersStrategy().handleMembersAboutToExpire(expiringMembers);
        List<VOMSUser> expiredMembers = this.getExpiredMembersLookupStrategy().findExpiredMembers();
        log.debug("Expired members: {}", expiredMembers);
        this.getHandleExpiredMembersStrategy().handleExpiredMembers(expiredMembers);
        List<VOMSUser> aupFailingMembers = this.getAupFailingMembersLookupStrategy().findAUPFailingMembers();
        log.debug("AUP failing members: {}", aupFailingMembers);
        this.getHandleAUPFailingMembersStrategy().handleAUPFailingMembers(aupFailingMembers);
    }

    @Override
    public void run() {
        this.checkMembershipStatus();
    }
}

