/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.tasks;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.persistence.dao.VOMSCADAO;
import org.glite.security.voms.admin.util.DNUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdateCATask
implements Runnable {
    static final Logger log = LoggerFactory.getLogger(UpdateCATask.class);

    private void directorySanityChecks(File directory) {
        if (!directory.exists()) {
            throw new VOMSException("Local trust directory does not exists:" + directory.getAbsolutePath());
        }
        if (!directory.isDirectory()) {
            throw new VOMSException("Local trust directory is not a directory:" + directory.getAbsolutePath());
        }
        if (!directory.canRead()) {
            throw new VOMSException("Local trust directory is not readable:" + directory.getAbsolutePath());
        }
        if (!directory.canExecute()) {
            throw new VOMSException("Local trust directory is not traversable:" + directory.getAbsolutePath());
        }
    }

    @Override
    public void run() {
        File[] certFiles;
        String trustAnchorsDir = VOMSConfiguration.instance().getString("voms.trust_anchors.dir", "/etc/grid-security/certificates");
        log.debug("Updating CAs from: " + trustAnchorsDir);
        VOMSCADAO dao = VOMSCADAO.instance();
        File dir = new File(trustAnchorsDir);
        this.directorySanityChecks(dir);
        for (File caFile : certFiles = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(".*\\.\\d");
            }
        })) {
            X509Certificate caCert;
            log.debug("Parsing CA certificate from {}.", (Object)caFile);
            try {
                caCert = CertificateUtils.loadCertificate((InputStream)new FileInputStream(caFile), (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                continue;
            }
            String caDN = DNUtil.getOpenSSLSubject(caCert.getSubjectX500Principal());
            log.debug("Checking CA: " + caDN);
            dao.createIfMissing(caDN, null);
        }
    }
}

