/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.tasks;

import java.util.Date;
import java.util.List;
import org.glite.security.voms.admin.core.tasks.RegistrationServiceTask;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.TaskDAO;
import org.glite.security.voms.admin.persistence.model.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStatusUpdater
implements Runnable,
RegistrationServiceTask {
    public static Logger log = LoggerFactory.getLogger(TaskStatusUpdater.class);

    @Override
    public void run() {
        TaskDAO taskDAO = DAOFactory.instance().getTaskDAO();
        List<Task> activeTasks = taskDAO.getActiveTasks();
        for (Task t : activeTasks) {
            Date now = new Date();
            if (!t.getExpiryDate().before(now)) continue;
            log.debug("Task " + t + " has expired, setting its status to EXPIRED.");
            t.setStatus(Task.TaskStatus.EXPIRED);
        }
    }
}

