/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.tasks;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.core.tasks.RegistrationServiceTask;
import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.registration.VOMembershipRequestExpiredEvent;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.RequestDAO;
import org.glite.security.voms.admin.persistence.model.request.NewVOMembershipRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiredRequestsPurgerTask
implements Runnable,
RegistrationServiceTask {
    private static final Logger log = LoggerFactory.getLogger(ExpiredRequestsPurgerTask.class);
    private long requestLifetime;
    private boolean warnUsers;

    public ExpiredRequestsPurgerTask() {
        VOMSConfiguration conf = VOMSConfiguration.instance();
        this.requestLifetime = conf.getLong("voms.request.vo_membership.lifetime", TimeUnit.DAYS.toSeconds(7L));
        this.warnUsers = conf.getBoolean("voms.request.vo_membership.warn_when_expired", false);
    }

    @Override
    public void run() {
        if (this.requestLifetime < 0L) {
            log.debug("Request purger NOT STARTED since a negative lifetime for requests was set in configuration.");
            return;
        }
        RequestDAO dao = DAOFactory.instance().getRequestDAO();
        List<NewVOMembershipRequest> expiredRequests = dao.findExpiredVOMembershipRequests();
        for (NewVOMembershipRequest req : expiredRequests) {
            log.info("Removing unconfirmed request '{}' from database since the confirmation period has expired.", (Object)req);
            dao.makeTransient(req);
            if (!this.warnUsers) continue;
            EventManager.dispatch(new VOMembershipRequestExpiredEvent(req));
        }
    }
}

