/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.tasks;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.HibernateFactory;
import org.glite.security.voms.admin.persistence.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSCADAO;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSVersionDAO;
import org.glite.security.voms.admin.persistence.dao.generic.AUPDAO;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.TaskTypeDAO;
import org.glite.security.voms.admin.persistence.error.VOMSInconsistentDatabaseException;
import org.glite.security.voms.admin.persistence.model.ACL;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.persistence.model.VOMSSeqNumber;
import org.glite.security.voms.admin.persistence.model.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSetupTask
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSetupTask.class);
    private Timer timer;
    private static DatabaseSetupTask instance = null;

    public static DatabaseSetupTask instance() {
        return DatabaseSetupTask.instance(null);
    }

    public static DatabaseSetupTask instance(Timer t) {
        if (instance == null) {
            instance = new DatabaseSetupTask(t);
        }
        return instance;
    }

    private DatabaseSetupTask(Timer timer) {
        this.timer = timer;
    }

    private void setupRootGroup() {
        try {
            VOMSGroupDAO.instance().getVOGroup();
        }
        catch (VOMSInconsistentDatabaseException ex) {
            log.info("Setting up VO root group...");
            VOMSGroupDAO.instance().createVOGroup();
        }
    }

    private void setupInternalCAs() {
        log.info("Setting up voms-admin internal CAs..");
        VOMSCADAO caDAO = VOMSCADAO.instance();
        caDAO.createIfMissing("/O=VOMS/O=System/CN=Dummy Certificate Authority", "A dummy CA for local org.glite.security.voms.admin.persistence.error mainteneance");
        caDAO.createIfMissing("/O=VOMS/O=System/CN=VOMS Group", "A virtual CA for VOMS groups.");
        caDAO.createIfMissing("/O=VOMS/O=System/CN=VOMS Role", "A virtual CA for VOMS roles.");
        caDAO.createIfMissing("/O=VOMS/O=System/CN=Authorization Manager Attributes", "A virtual CA for authz manager attributes");
    }

    private void setupInternalAdmins() {
        List admins = VOMSAdminDAO.instance().getAll();
        if (admins.isEmpty()) {
            log.info("Setting up voms-admin internal administrators...");
            VOMSGroup voGroup = VOMSGroupDAO.instance().getVOGroup();
            if (voGroup == null) {
                this.setupRootGroup();
            }
            VOMSAdminDAO adminDAO = VOMSAdminDAO.instance();
            VOMSAdmin internalAdmin = adminDAO.create("/O=VOMS/O=System/CN=Internal VOMS Process", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
            VOMSAdmin localAdmin = adminDAO.create("/O=VOMS/O=System/CN=Local Database Administrator", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
            adminDAO.create("/O=VOMS/O=System/CN=Absolutely Anyone", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
            adminDAO.create("/O=VOMS/O=System/CN=Any Authenticated User", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
            adminDAO.create("/O=VOMS/O=System/CN=Unauthenticated Client", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
            VOMSPermission allPermissions = VOMSPermission.getAllPermissions();
            ACL voGroupACL = new ACL(voGroup, false);
            voGroup.getAcls().add(voGroupACL);
            voGroupACL.setPermissions(localAdmin, allPermissions);
            voGroupACL.setPermissions(internalAdmin, allPermissions);
            VOMSRole voAdminRole = VOMSRoleDAO.instance().create("VO-Admin");
            VOMSAdmin voAdmin = VOMSAdminDAO.instance().create(voGroup.getName() + "/Role=VO-Admin");
            voGroupACL.setPermissions(voAdmin, allPermissions);
            voAdminRole.importACL(voGroup);
            VOMSSeqNumber seqNum = new VOMSSeqNumber();
            seqNum.setSeq("0");
            HibernateFactory.getSession().save((Object)seqNum);
        }
    }

    public void setupTasks() {
        TaskTypeDAO ttDAO = DAOFactory.instance(DAOFactory.HIBERNATE).getTaskTypeDAO();
        if (ttDAO.findAll().isEmpty()) {
            log.info("Setting up voms-admin task infrastructure...");
            TaskType signAupTaskType = new TaskType();
            signAupTaskType.setName("SignAUPTask");
            signAupTaskType.setDescription("Tasks of this type are assigned to users that need to sign, or resign an AUP.");
            TaskType approveUserRequestTaskType = new TaskType();
            approveUserRequestTaskType.setName("ApproveUserRequestTask");
            approveUserRequestTaskType.setDescription("Tasks of this type are assigned to VO admins that need to approve users' requests.");
            ttDAO.makePersistent(signAupTaskType);
            ttDAO.makePersistent(approveUserRequestTaskType);
        }
    }

    public void setupAUP() {
        AUPDAO dao = DAOFactory.instance().getAUPDAO();
        if (dao.findAll().isEmpty()) {
            log.info("Setting up voms-admin aup infrastructure...");
            String voAUPUrlString = VOMSConfiguration.instance().getString("voms.aup.vo_aup.initial_url", VOMSConfiguration.instance().getDefaultVOAUPURL());
            if (voAUPUrlString.trim().equals("")) {
                log.warn("No url defined for VO AUP, using default setting...");
                voAUPUrlString = VOMSConfiguration.instance().getDefaultVOAUPURL();
            }
            try {
                URL voAUPURL = new URL(voAUPUrlString);
                AUPDAO aupDAO = DAOFactory.instance().getAUPDAO();
                aupDAO.createVOAUP("", "1.0", voAUPURL);
            }
            catch (MalformedURLException e) {
                log.error("Error parsing AUP url: " + e.getMessage());
                log.error("Skipping creation of AUPs");
            }
        }
    }

    @Override
    public void run() {
        this.setupRootGroup();
        this.setupInternalCAs();
        this.setupInternalAdmins();
        VOMSVersionDAO.instance().setupVersion();
        this.setupTasks();
        this.setupAUP();
        HibernateFactory.commitTransaction();
    }
}

