/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.x509;

import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

class VOMSResponseFragment {
    private Document doc;
    DocumentFragment fragment;

    public VOMSResponseFragment(Document document) {
        this.doc = document;
        this.fragment = this.doc.createDocumentFragment();
    }

    public void buildACElement(String base64EncodedACString) {
        Element root = this.doc.createElement("voms");
        this.fragment.appendChild(root);
        Element ac = this.doc.createElement("ac");
        this.appendTextChild(ac, base64EncodedACString);
        root.appendChild(ac);
    }

    public void buildErrorElement(String errorCode, String errorMessage) {
        Element error = this.doc.createElement("error");
        Element errorCodeElement = this.doc.createElement("code");
        Element errorMessageElement = this.doc.createElement("message");
        this.appendTextChild(errorMessageElement, errorMessage);
        this.appendTextChild(errorCodeElement, errorCode);
        error.appendChild(errorCodeElement);
        error.appendChild(errorMessageElement);
        this.fragment.appendChild(error);
    }

    public DocumentFragment getFragment() {
        return this.fragment;
    }

    protected void appendTextChild(Element e, String text) {
        assert (e != null) : "Cannot append a text child to a null element!";
        assert (text != null) : "Cannot append a null text to an element!";
        e.appendChild(this.doc.createTextNode(text));
    }
}

