/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.x509;

import it.infn.cnaf.voms.aa.VOMSAA;
import it.infn.cnaf.voms.aa.VOMSAttributeAuthority;
import it.infn.cnaf.voms.aa.VOMSAttributes;
import it.infn.cnaf.voms.x509.BaseServlet;
import it.infn.cnaf.voms.x509.VOMSErrorCodes;
import it.infn.cnaf.voms.x509.VOMSResponseFactory;
import it.infn.cnaf.voms.x509.X509ACGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.x509.X509V2AttributeCertificate;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.error.VOMSSyntaxException;
import org.glite.security.voms.admin.operations.CurrentAdmin;
import org.glite.security.voms.admin.persistence.error.NoSuchCertificateException;
import org.glite.security.voms.admin.persistence.error.NoSuchUserException;
import org.glite.security.voms.admin.persistence.error.SuspendedCertificateException;
import org.glite.security.voms.admin.persistence.error.SuspendedUserException;
import org.italiangrid.utils.voms.SecurityContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ACServlet
extends BaseServlet
implements VOMSErrorCodes {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ACServlet.class);
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();

    protected void serializeXMLDoc(Document doc, Writer writer) {
        Transformer transformer;
        try {
            transformer = this.transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            log.error("Error creating XML transformer:" + e.getMessage());
            if (log.isDebugEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error creating XML transformer:", e);
        }
        DOMSource source = new DOMSource(doc);
        StreamResult res = new StreamResult(writer);
        try {
            transformer.transform(source, res);
            writer.flush();
        }
        catch (Exception e) {
            log.error("Error caught serializing XML :" + e.getMessage());
            if (log.isDebugEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error caugh serializing XML :", e);
        }
    }

    protected String xmlDocAsString(Document doc) {
        Transformer transformer;
        try {
            transformer = this.transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            log.error("Error creating XML transformer:" + e.getMessage());
            if (log.isDebugEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error creating XML transformer:", e);
        }
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(doc);
        StreamResult res = new StreamResult(writer);
        try {
            transformer.transform(source, res);
        }
        catch (TransformerException e) {
            log.error("Error caught serializing XML :" + e.getMessage());
            if (log.isDebugEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error caugh serializing XML :", e);
        }
        writer.flush();
        return writer.toString();
    }

    protected void writeErrorResponse(HttpServletResponse response, int httpErrorCode, String vomsErrorCode, String message) throws ServletException, IOException {
        VOMSResponseFactory responseFactory = VOMSResponseFactory.instance();
        Document xmlResponse = responseFactory.buildErrorResponse(vomsErrorCode, message);
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(httpErrorCode);
        this.serializeXMLDoc(xmlResponse, response.getWriter());
    }

    protected void writeResponse(HttpServletResponse response, byte[] ac) throws ServletException, IOException {
        VOMSResponseFactory responseFactory = VOMSResponseFactory.instance();
        Document xmlResponse = responseFactory.buildResponse(ac);
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(this.xmlDocAsString(xmlResponse));
    }

    protected List<String> parseRequestedFQANs(HttpServletRequest request) {
        String fqansString = request.getParameter("fqans");
        if (fqansString == null) {
            return null;
        }
        ArrayList<String> requestedFQANs = new ArrayList<String>();
        if (fqansString.contains(",")) {
            for (String s : StringUtils.split((String)fqansString, (String)",")) {
                requestedFQANs.add(s);
            }
        } else {
            requestedFQANs.add(fqansString);
        }
        return requestedFQANs;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        VOMSAttributes attrs;
        VOMSAttributeAuthority vomsAA = VOMSAA.getVOMSAttributeAuthority();
        if (!VOMSConfiguration.instance().getBoolean("voms.aa.activate_rest_endpoint", false)) {
            this.writeErrorResponse(response, 500, "InternalError", "REST endpoint is disabled for this VO");
            return;
        }
        if (CurrentAdmin.instance().isUnauthenticated()) {
            this.writeErrorResponse(response, 400, "BadRequest", "Please authenticated with an X509 certificate to obtain a VOMS attribute certificate");
            return;
        }
        String clientDN = CurrentAdmin.instance().getRealSubject();
        List<String> requestedFQANs = this.parseRequestedFQANs(request);
        try {
            attrs = requestedFQANs == null || requestedFQANs.size() == 0 ? vomsAA.getVOMSAttributes(clientDN) : vomsAA.getVOMSAttributes(clientDN, requestedFQANs);
        }
        catch (VOMSException e) {
            String vomsErrorCode;
            int httpErrorCode;
            log.error("Error getting VOMS attributes for user '" + clientDN + "':" + e.getMessage());
            if (e instanceof NoSuchUserException || e instanceof NoSuchCertificateException) {
                httpErrorCode = 403;
                vomsErrorCode = "NoSuchUser";
            } else if (e instanceof SuspendedUserException) {
                httpErrorCode = 403;
                vomsErrorCode = "SuspendedUser";
            } else if (e instanceof SuspendedCertificateException) {
                httpErrorCode = 403;
                vomsErrorCode = "SuspendedCertificate";
            } else if (e instanceof VOMSSyntaxException) {
                httpErrorCode = 400;
                vomsErrorCode = "BadRequest";
            } else {
                httpErrorCode = 500;
                vomsErrorCode = "InternalError";
            }
            this.writeErrorResponse(response, httpErrorCode, vomsErrorCode, e.getMessage());
            return;
        }
        long lifetime = -1L;
        try {
            String lifetimeString = request.getParameter("lifetime");
            if (lifetimeString != null) {
                lifetime = this.parseLong(request.getParameter("lifetime"));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        SecurityContextImpl ctxt = SecurityContextImpl.getCurrentContext();
        if (ctxt.getClientCert() == null) {
            throw new VOMSException("No client certificate found in the request!");
        }
        X509ACGenerator acGen = X509ACGenerator.instance();
        if (lifetime > 0L) {
            acGen.setLifetime(lifetime);
        }
        X509V2AttributeCertificate ac = acGen.generateVOMSAttributeCertificate(ctxt.getClientCert(), attrs);
        byte[] acBytes = null;
        try {
            acBytes = ac.getEncoded();
        }
        catch (IOException e) {
            log.error("Error encoding user attribute certificate: " + e.getMessage());
            this.writeErrorResponse(response, 500, "InternalError", e.getMessage());
            return;
        }
        response.addHeader("VomsFQANs", StringUtils.join(attrs.getFqans(), (String)","));
        response.addHeader("VomsGenericAttributes", StringUtils.join(attrs.getGenericAttributes(), (String)","));
        this.writeResponse(response, acBytes);
    }
}

