/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.saml.emi;

import it.infn.cnaf.voms.aa.VOMSFQAN;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.glite.security.voms.admin.util.PathNamingScheme;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.impl.AttributeBuilder;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSAnyBuilder;
import org.opensaml.xml.schema.impl.XSStringBuilder;

public class AttributeWizard {
    public static final QName ROLE_XSD_TYPE = new QName("http://dci-sec.org/saml/profile/virtual-organization/1.0", "role", "dci-sec");
    public static final QName VO_XSD_TYPE = new QName("http://dci-sec.org/saml/profile/virtual-organization/1.0", "vo", "dci-sec");
    public static final QName SCOPE_XSD_ATTRIBUTE = new QName("http://dci-sec.org/saml/profile/virtual-organization/1.0", "scope", "dci-sec");

    public static Attribute createAttribute(String attributeName) {
        XMLObjectBuilderFactory bf = Configuration.getBuilderFactory();
        AttributeBuilder attributeBuilder = (AttributeBuilder)bf.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        Attribute attr = attributeBuilder.buildObject();
        attr.setName(attributeName);
        attr.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        return attr;
    }

    public static XSAny createAttributeValue(QName type, String value) {
        XMLObjectBuilderFactory bf = Configuration.getBuilderFactory();
        XSAnyBuilder builder = (XSAnyBuilder)bf.getBuilder(XSAny.TYPE_NAME);
        XSAny attrVal = (XSAny)builder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, type);
        attrVal.setTextContent(value);
        return attrVal;
    }

    public static XSString createStringAttributeValue(String value) {
        XMLObjectBuilderFactory bf = Configuration.getBuilderFactory();
        XSStringBuilder builder = (XSStringBuilder)bf.getBuilder(XSString.TYPE_NAME);
        XSString attrVal = (XSString)builder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        attrVal.setValue(value);
        return attrVal;
    }

    public static XSAny createRoleAttributeValue(String fqan) {
        String role = PathNamingScheme.getRoleName(fqan);
        String group = PathNamingScheme.getGroupName(fqan);
        XSAny roleAttrVal = AttributeWizard.createAttributeValue(ROLE_XSD_TYPE, role);
        roleAttrVal.getUnknownAttributes().put(SCOPE_XSD_ATTRIBUTE, group);
        return roleAttrVal;
    }

    public static Attribute createGroupAttributeFromStrings(List<String> fqans) {
        Attribute groupAttr = AttributeWizard.createAttribute("http://dci-sec.org/saml/attribute/group");
        for (String f : fqans) {
            groupAttr.getAttributeValues().add(AttributeWizard.createStringAttributeValue(f));
        }
        return groupAttr;
    }

    public static Attribute createGroupAttribute(List<VOMSFQAN> fqans) {
        Attribute groupAttr = AttributeWizard.createAttribute("http://dci-sec.org/saml/attribute/group");
        for (VOMSFQAN f : fqans) {
            if (!f.isGroup()) continue;
            groupAttr.getAttributeValues().add(AttributeWizard.createStringAttributeValue(f.getFQAN()));
        }
        return groupAttr;
    }

    public static Attribute createPrimaryGroupAttributeFromString(String fqan) {
        Attribute pGroupAttr = AttributeWizard.createAttribute("http://dci-sec.org/saml/attribute/group/primary");
        if (fqan != null) {
            pGroupAttr.getAttributeValues().add(AttributeWizard.createStringAttributeValue(fqan));
        }
        return pGroupAttr;
    }

    public static Attribute createPrimaryGroupAttribute(VOMSFQAN fqan) {
        Attribute pGroupAttr = AttributeWizard.createAttribute("http://dci-sec.org/saml/attribute/group/primary");
        if (fqan.isGroup()) {
            pGroupAttr.getAttributeValues().add(AttributeWizard.createStringAttributeValue(fqan.getFQAN()));
        }
        return pGroupAttr;
    }

    public static List<String> attributeToListOfStrings(Attribute attr) {
        ArrayList<String> result = new ArrayList<String>();
        List attributeValues = attr.getAttributeValues();
        for (XMLObject o : attributeValues) {
            XSString stringContent = (XSString)o;
            result.add(stringContent.getValue());
        }
        return result;
    }

    public static List<String> roleAttributeToFQAN(Attribute roleAttr) {
        ArrayList<String> result = new ArrayList<String>();
        if (!roleAttr.getName().equals("http://dci-sec.org/saml/attribute/role") && !roleAttr.getName().equals("http://dci-sec.org/saml/attribute/role/primary")) {
            throw new IllegalArgumentException("Unsupported attribute name: " + roleAttr.getName());
        }
        List attributeValues = roleAttr.getAttributeValues();
        for (XMLObject o : attributeValues) {
            XSAny roleContent = (XSAny)o;
            String roleName = roleContent.getTextContent();
            QName scopeAttributeName = new QName("http://dci-sec.org/saml/profile/virtual-organization/1.0", "scope");
            String groupScope = roleContent.getUnknownAttributes().get((Object)scopeAttributeName);
            if (groupScope == null) continue;
            String roleFQAN = String.format("%s/Role=%s", groupScope, roleName);
            result.add(roleFQAN);
        }
        return result;
    }

    public static Attribute createRoleAttributeFromStrings(List<String> fqans) {
        Attribute roleAttr = AttributeWizard.createAttribute("http://dci-sec.org/saml/attribute/role");
        for (String f : fqans) {
            if (!PathNamingScheme.isQualifiedRole(f)) continue;
            roleAttr.getAttributeValues().add(AttributeWizard.createRoleAttributeValue(f));
        }
        return roleAttr;
    }

    public static Attribute createRoleAttribute(List<VOMSFQAN> fqans) {
        Attribute roleAttr = AttributeWizard.createAttribute("http://dci-sec.org/saml/attribute/role");
        for (VOMSFQAN f : fqans) {
            if (!f.isRole()) continue;
            roleAttr.getAttributeValues().add(AttributeWizard.createRoleAttributeValue(f.getFQAN()));
        }
        return roleAttr;
    }

    public static Attribute createPrimaryRoleAttributeFromString(String fqan) {
        Attribute pRoleAttr = AttributeWizard.createAttribute("http://dci-sec.org/saml/attribute/role/primary");
        if (fqan != null && PathNamingScheme.isQualifiedRole(fqan)) {
            pRoleAttr.getAttributeValues().add(AttributeWizard.createRoleAttributeValue(fqan));
        }
        return pRoleAttr;
    }

    public static Attribute createPrimaryRoleAttribute(VOMSFQAN fqan) {
        Attribute pRoleAttr = AttributeWizard.createAttribute("http://dci-sec.org/saml/attribute/role/primary");
        if (fqan.isRole()) {
            pRoleAttr.getAttributeValues().add(AttributeWizard.createRoleAttributeValue(fqan.getFQAN()));
        }
        return pRoleAttr;
    }

    public static Attribute createVOAttribute(String voName) {
        Attribute voAttr = AttributeWizard.createAttribute("http://dci-sec.org/saml/attribute/virtual-organization");
        voAttr.getAttributeValues().add(AttributeWizard.createStringAttributeValue(voName));
        return voAttr;
    }
}

