/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.saml;

import it.infn.cnaf.voms.saml.exceptions.IssuerPeerMismatchException;
import it.infn.cnaf.voms.saml.exceptions.UnauthorizedQueryException;
import it.infn.cnaf.voms.saml.exceptions.UnknownAttributeException;
import it.infn.cnaf.voms.saml.exceptions.UnknownPrincipalException;
import it.infn.cnaf.voms.saml.exceptions.VersionMismatchException;
import it.infn.cnaf.voms.saml.exceptions.X509SubjectWrongNameIDFormatException;
import it.infn.cnaf.voms.saml.exceptions.X509SubjectWrongNameIDValueException;
import java.util.HashMap;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import org.glite.security.voms.admin.persistence.error.SuspendedCertificateException;
import org.glite.security.voms.admin.persistence.error.SuspendedUserException;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.ResponseBuilder;
import org.opensaml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml2.core.impl.StatusMessageBuilder;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLResponseFactory {
    private static Logger logger = LoggerFactory.getLogger(SAMLResponseFactory.class);
    private static X500Principal issuer;
    private static HashMap<Class, String[]> statusMapper;

    public SAMLResponseFactory(X500Principal principal) {
        logger.info("Configuring ResponseFactory with issuer " + principal.getName());
        issuer = principal;
    }

    private Response create(String queryId) {
        XMLObjectBuilderFactory builderFactory = org.opensaml.Configuration.getBuilderFactory();
        ResponseBuilder responseBuilder = (ResponseBuilder)builderFactory.getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response response = responseBuilder.buildObject();
        response.setID("_" + UUID.randomUUID().toString());
        response.setIssueInstant(new DateTime());
        response.setInResponseTo(queryId);
        IssuerBuilder issuerBuilder = (IssuerBuilder)builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer responseIssuer = issuerBuilder.buildObject();
        responseIssuer.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        responseIssuer.setValue(issuer.getName());
        response.setIssuer(responseIssuer);
        return response;
    }

    public Response create(String queryId, Assertion assertion) {
        Response response = this.create(queryId);
        XMLObjectBuilderFactory builderFactory = org.opensaml.Configuration.getBuilderFactory();
        logger.debug("Setting Response status to urn:oasis:names:tc:SAML:2.0:status:Success");
        StatusBuilder statusBuilder = (StatusBuilder)builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status status = statusBuilder.buildObject();
        StatusCodeBuilder statusCodeBuilder = (StatusCodeBuilder)builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = statusCodeBuilder.buildObject();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        status.setStatusCode(statusCode);
        response.setStatus(status);
        response.getAssertions().add(assertion);
        return response;
    }

    public Response create(String queryId, Throwable exception) {
        Response response = this.create(queryId);
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        logger.debug("Setting Response status");
        StatusBuilder statusBuilder = (StatusBuilder)builderFactory.getBuilder(Status.DEFAULT_ELEMENT_NAME);
        Status status = statusBuilder.buildObject();
        StatusCodeBuilder statusCodeBuilder = (StatusCodeBuilder)builderFactory.getBuilder(StatusCode.DEFAULT_ELEMENT_NAME);
        StatusCode statusCode = statusCodeBuilder.buildObject();
        StatusCode subStatusCode = statusCodeBuilder.buildObject();
        String[] mapped = statusMapper.get(exception.getClass());
        if (mapped != null) {
            statusCode.setValue(mapped[0]);
            if (mapped.length == 2) {
                subStatusCode.setValue(mapped[1]);
                statusCode.setStatusCode(subStatusCode);
            }
        } else {
            statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Responder");
        }
        if (exception.getMessage() != null) {
            StatusMessageBuilder statusMessageBuilder = (StatusMessageBuilder)builderFactory.getBuilder(StatusMessage.DEFAULT_ELEMENT_NAME);
            StatusMessage statusMessage = statusMessageBuilder.buildObject();
            statusMessage.setMessage(exception.getMessage());
            status.setStatusMessage(statusMessage);
        }
        status.setStatusCode(statusCode);
        response.setStatus(status);
        return response;
    }

    static {
        statusMapper = new HashMap();
        statusMapper.put(VersionMismatchException.class, new String[]{"urn:oasis:names:tc:SAML:2.0:status:VersionMismatch"});
        statusMapper.put(UnknownAttributeException.class, new String[]{"urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnknownAttrProfile"});
        statusMapper.put(UnknownPrincipalException.class, new String[]{"urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal"});
        statusMapper.put(UnauthorizedQueryException.class, new String[]{"urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied"});
        statusMapper.put(X509SubjectWrongNameIDValueException.class, new String[]{"urn:oasis:names:tc:SAML:2.0:status:Requester"});
        statusMapper.put(X509SubjectWrongNameIDFormatException.class, new String[]{"urn:oasis:names:tc:SAML:2.0:status:Requester"});
        statusMapper.put(IssuerPeerMismatchException.class, new String[]{"urn:oasis:names:tc:SAML:2.0:status:Requester"});
        statusMapper.put(SuspendedCertificateException.class, new String[]{"urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied"});
        statusMapper.put(SuspendedUserException.class, new String[]{"urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied"});
        statusMapper.put(Exception.class, new String[]{"urn:oasis:names:tc:SAML:2.0:status:Responder"});
    }
}

