/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.aa.impl;

import it.infn.cnaf.voms.aa.VOMSAttributes;
import it.infn.cnaf.voms.aa.VOMSFQAN;
import it.infn.cnaf.voms.aa.VOMSGenericAttribute;
import it.infn.cnaf.voms.aa.VOMSUser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.persistence.error.SuspendedUserException;
import org.glite.security.voms.admin.persistence.model.VOMSBaseAttribute;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSMapping;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.persistence.model.VOMSUserAttribute;
import org.glite.security.voms.admin.util.PathNamingScheme;

class VOMSAttributesImpl
implements VOMSAttributes {
    VOMSUser user;
    List<VOMSFQAN> fqans = new ArrayList<VOMSFQAN>();
    List<VOMSGenericAttribute> genericAttributes = new ArrayList<VOMSGenericAttribute>();

    private VOMSAttributesImpl() {
    }

    @Override
    public List<VOMSFQAN> getFqans() {
        return this.fqans;
    }

    @Override
    public List<VOMSGenericAttribute> getGenericAttributes() {
        return this.genericAttributes;
    }

    @Override
    public VOMSUser getUser() {
        return this.user;
    }

    public void setUser(VOMSUser user) {
        this.user = user;
    }

    void getGroupsFromUser(org.glite.security.voms.admin.persistence.model.VOMSUser user) {
        assert (user != null) : "Cannot get groups from a NULL user!";
        for (VOMSMapping m : user.getMappings()) {
            if (!m.isGroupMapping()) continue;
            this.fqans.add(VOMSFQAN.fromModel(m));
        }
    }

    void getRolesFromUser(org.glite.security.voms.admin.persistence.model.VOMSUser user) {
        assert (user != null) : "Cannot get roles from a NULL user!";
        for (VOMSMapping m : user.getMappings()) {
            if (!m.isRoleMapping()) continue;
            this.fqans.add(VOMSFQAN.fromModel(m));
        }
    }

    private void addMissingFQANsForUser(org.glite.security.voms.admin.persistence.model.VOMSUser user) {
        assert (user != null) : "Cannot add missing FQANs for a NULL user!";
        for (VOMSMapping mapping : user.getMappings()) {
            VOMSFQAN possiblyMissingFQAN;
            if (!mapping.isGroupMapping() || this.fqans.contains(possiblyMissingFQAN = VOMSFQAN.fromModel(mapping))) continue;
            this.fqans.add(possiblyMissingFQAN);
        }
    }

    void getFQANsFromUser(org.glite.security.voms.admin.persistence.model.VOMSUser user, List<String> requestedFQANs) {
        assert (user != null) : "Cannot get FQANs from a NULL user!";
        assert (requestedFQANs != null && !requestedFQANs.isEmpty()) : "Cannot select FQANs from a NULL of empty FQAN list!";
        for (String fqan : requestedFQANs) {
            if (PathNamingScheme.isQualifiedRole(fqan)) {
                if (!user.hasRole(fqan)) continue;
                this.fqans.add(VOMSFQAN.fromString(fqan));
                continue;
            }
            if (!PathNamingScheme.isGroup(fqan) || !user.isMember(fqan)) continue;
            this.fqans.add(VOMSFQAN.fromString(fqan));
        }
    }

    void getGenericAttributesFromUser(org.glite.security.voms.admin.persistence.model.VOMSUser user) {
        assert (user != null) : "Cannot get Generic Attributes from a NULL user!";
        for (VOMSUserAttribute attribute : user.getAttributes()) {
            this.genericAttributes.add(VOMSGenericAttribute.fromModel(attribute));
        }
        for (VOMSFQAN requestedFQAN : this.fqans) {
            if (requestedFQAN.isGroup()) {
                VOMSGroup g = VOMSGroupDAO.instance().findByName(requestedFQAN.getFQAN());
                Iterator groupAttrsIter = g.getAttributes().iterator();
                while (groupAttrsIter.hasNext()) {
                    this.genericAttributes.add(VOMSGenericAttribute.fromModel((VOMSBaseAttribute)groupAttrsIter.next()));
                }
                continue;
            }
            if (!requestedFQAN.isRole()) continue;
            String roleName = PathNamingScheme.getRoleName(requestedFQAN.getFQAN());
            String groupName = PathNamingScheme.getGroupName(requestedFQAN.getFQAN());
            VOMSRole r = VOMSRoleDAO.instance().findByName(roleName);
            VOMSGroup g = VOMSGroupDAO.instance().findByName(groupName);
            Iterator roleAttrsIter = r.getAttributesInGroup(g).iterator();
            while (roleAttrsIter.hasNext()) {
                this.genericAttributes.add(VOMSGenericAttribute.fromModel((VOMSBaseAttribute)roleAttrsIter.next()));
            }
        }
    }

    public static VOMSAttributesImpl fromUser(org.glite.security.voms.admin.persistence.model.VOMSUser user) {
        return VOMSAttributesImpl.fromUser(user, null);
    }

    public static VOMSAttributesImpl fromUser(org.glite.security.voms.admin.persistence.model.VOMSUser user, List<String> requestedFQANs) {
        assert (user != null) : "Cannot get VOMS attributes for a NULL user!";
        if (user.isSuspended()) {
            throw new SuspendedUserException("User '" + user.getShortName() + "' is currently suspended for the following reason: " + user.getSuspensionReason());
        }
        VOMSAttributesImpl attrs = new VOMSAttributesImpl();
        attrs.setUser(VOMSUser.fromModel(user));
        if (requestedFQANs == null) {
            attrs.getGroupsFromUser(user);
            attrs.getGenericAttributesFromUser(user);
        } else {
            attrs.getFQANsFromUser(user, requestedFQANs);
            attrs.getGenericAttributesFromUser(user);
            boolean compulsoryGroupMembership = VOMSConfiguration.instance().getBoolean("voms.aa.compulsory_group_membership", new Boolean(true));
            if (compulsoryGroupMembership) {
                attrs.addMissingFQANsForUser(user);
            }
        }
        return attrs;
    }

    public static VOMSAttributes getAllFromUser(org.glite.security.voms.admin.persistence.model.VOMSUser user) {
        assert (user != null) : "Cannot get all VOMS attributes for a NULL user!";
        if (user.isSuspended()) {
            throw new SuspendedUserException("User '" + user.getShortName() + "' is currently suspended for the following reason: " + user.getSuspensionReason());
        }
        VOMSAttributesImpl attrs = new VOMSAttributesImpl();
        attrs.setUser(VOMSUser.fromModel(user));
        attrs.getGroupsFromUser(user);
        attrs.getRolesFromUser(user);
        attrs.getGenericAttributesFromUser(user);
        return attrs;
    }

    @Override
    public boolean hasRoles() {
        for (VOMSFQAN f : this.getFqans()) {
            if (!f.isRole()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.fqans == null || this.fqans.isEmpty()) {
            return "[]";
        }
        return this.fqans.toString();
    }
}

