/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.aa;

import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.persistence.model.VOMSBaseAttribute;
import org.glite.security.voms.admin.util.PathNamingScheme;

public class VOMSGenericAttribute {
    String name;
    String value;
    String context;

    private VOMSGenericAttribute() {
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isUserAttribute() {
        assert (this.context != null && !this.context.equals(""));
        String voRootGroupName = "/" + VOMSConfiguration.instance().getVOName();
        return this.context.equals(voRootGroupName);
    }

    public boolean isGroupAttribute() {
        assert (this.context != null && !this.context.equals(""));
        return PathNamingScheme.isGroup(this.context);
    }

    public boolean isRoleAttribute() {
        assert (this.context != null && !this.context.equals(""));
        return PathNamingScheme.isQualifiedRole(this.context);
    }

    public static VOMSGenericAttribute fromModel(VOMSBaseAttribute attributeValue) {
        assert (attributeValue != null);
        VOMSGenericAttribute ga = new VOMSGenericAttribute();
        ga.setName(attributeValue.getAttributeDescription().getName());
        ga.setValue(attributeValue.getValue());
        if (attributeValue.getContext() == null) {
            ga.setContext(VOMSConfiguration.instance().getVOName());
        } else {
            ga.setContext(attributeValue.getContext());
        }
        return ga;
    }

    public String toString() {
        return String.format("%s = %s (%s)", this.name, this.value, this.context);
    }
}

