/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.EventListener;
import java.util.Properties;
import java.util.concurrent.Executor;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.aq.AQNotificationEvent;
import oracle.jdbc.aq.AQNotificationListener;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.NTFDCNEvent;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;

abstract class NTFRegistration {
    private final boolean jdbcGetsNotification;
    private final String clientHost;
    private final int clientTCPPort;
    private final Properties options;
    private final boolean isPurgeOnNTF;
    private final String username;
    private final int namespace;
    private final int jdbcRegId;
    private final String dbName;
    private final short databaseVersion;
    private NotificationRegistration.RegistrationState state;
    private NTFEventListener[] listeners = new NTFEventListener[0];
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Aug_23_13:33:58_PDT_2011";
    public static final boolean TRACE = false;

    NTFRegistration(int n2, int n3, boolean bl, String string, String string2, int n4, Properties properties, String string3, short s2) {
        this.namespace = n3;
        this.clientHost = string2;
        this.clientTCPPort = n4;
        this.options = properties;
        this.jdbcRegId = n2;
        this.username = string3;
        this.jdbcGetsNotification = bl;
        this.dbName = string;
        this.state = NotificationRegistration.RegistrationState.ACTIVE;
        this.isPurgeOnNTF = this.options.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0;
        this.databaseVersion = s2;
    }

    short getDatabaseVersion() {
        return this.databaseVersion;
    }

    synchronized void addListener(NTFEventListener nTFEventListener) throws SQLException {
        if (this.state == NotificationRegistration.RegistrationState.CLOSED) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 251);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (!this.jdbcGetsNotification) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 247);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = this.listeners.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.listeners[i2].getListener() != nTFEventListener.getListener()) continue;
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 248);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        NTFEventListener[] nTFEventListenerArray = new NTFEventListener[n2 + 1];
        System.arraycopy(this.listeners, 0, nTFEventListenerArray, 0, n2);
        nTFEventListenerArray[n2] = nTFEventListener;
        this.listeners = nTFEventListenerArray;
    }

    synchronized void removeListener(EventListener eventListener) throws SQLException {
        int n2 = 0;
        int n3 = this.listeners.length;
        for (n2 = 0; n2 < n3 && this.listeners[n2].getListener() != eventListener; ++n2) {
        }
        if (n2 == n3) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 249);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        NTFEventListener[] nTFEventListenerArray = new NTFEventListener[n3 - 1];
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.listeners[n2].getListener() == eventListener) continue;
            nTFEventListenerArray[n4++] = this.listeners[n2];
        }
        this.listeners = nTFEventListenerArray;
    }

    void notify(final NTFDCNEvent nTFDCNEvent) {
        long l2 = 0L;
        NTFEventListener[] nTFEventListenerArray = this.listeners;
        int n2 = nTFEventListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Executor executor = nTFEventListenerArray[i2].getExecutor();
            if (executor != null) {
                final DatabaseChangeListener databaseChangeListener = nTFEventListenerArray[i2].getDCNListener();
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        databaseChangeListener.onDatabaseChangeNotification(nTFDCNEvent);
                    }
                });
                continue;
            }
            nTFEventListenerArray[i2].getDCNListener().onDatabaseChangeNotification(nTFDCNEvent);
        }
        if (nTFDCNEvent.isDeregistrationEvent() || this.isPurgeOnNTF) {
            PhysicalConnection.ntfManager.removeRegistration(this);
            PhysicalConnection.ntfManager.freeJdbcRegId(this.getJdbcRegId());
            PhysicalConnection.ntfManager.cleanListenersT4C(this.getClientTCPPort());
            this.state = NotificationRegistration.RegistrationState.CLOSED;
        }
    }

    void notify(final NTFAQEvent nTFAQEvent) {
        long l2 = 0L;
        NTFEventListener[] nTFEventListenerArray = this.listeners;
        int n2 = nTFEventListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Executor executor = nTFEventListenerArray[i2].getExecutor();
            if (executor != null) {
                final AQNotificationListener aQNotificationListener = nTFEventListenerArray[i2].getAQListener();
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        aQNotificationListener.onAQNotification(nTFAQEvent);
                    }
                });
                continue;
            }
            nTFEventListenerArray[i2].getAQListener().onAQNotification(nTFAQEvent);
        }
        if (nTFAQEvent.getEventType() == AQNotificationEvent.EventType.DEREG || this.isPurgeOnNTF) {
            PhysicalConnection.ntfManager.removeRegistration(this);
            PhysicalConnection.ntfManager.freeJdbcRegId(this.getJdbcRegId());
            PhysicalConnection.ntfManager.cleanListenersT4C(this.getClientTCPPort());
            this.state = NotificationRegistration.RegistrationState.CLOSED;
        }
    }

    public Properties getRegistrationOptions() {
        return this.options;
    }

    int getJdbcRegId() {
        return this.jdbcRegId;
    }

    public String getUserName() {
        return this.username;
    }

    String getClientHost() {
        return this.clientHost;
    }

    int getClientTCPPort() {
        return this.clientTCPPort;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public NotificationRegistration.RegistrationState getState() {
        return this.state;
    }

    protected void setState(NotificationRegistration.RegistrationState registrationState) {
        this.state = registrationState;
    }

    int getNamespace() {
        return this.namespace;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

