#
# Copyright (c) Members of the EGEE Collaboration. 2006-2009.
# See http://www.eu-egee.org/partners/ for details on the copyright holders.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Authors:
# 	Andrea Ceccanti (INFN)
#

################################################## 
# VOMSCertificatesService_services_types.py 
# generated by ZSI.generate.wsdl2python
##################################################


import ZSI
import ZSI.TCcompound
from ZSI.schema import LocalElementDeclaration, ElementDeclaration, TypeDefinition, GTD, GED
from ZSI.generate.pyclass import pyclass_type

##############################
# targetNamespace
# http://glite.org/wsdl/services/org.glite.security.voms.service.certificates
##############################

class ns0:
    targetNamespace = "http://glite.org/wsdl/services/org.glite.security.voms.service.certificates"

    class X509Certificate_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://glite.org/wsdl/services/org.glite.security.voms.service.certificates"
        type = (schema, "X509Certificate")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.X509Certificate_Def.schema
            TClist = [ZSI.TC.Base64String(pname="bytes", aname="_bytes", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TCnumbers.Ilong(pname="id", aname="_id", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="issuer", aname="_issuer", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="notAfter", aname="_notAfter", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="subject", aname="_subject", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                __metaclass__ = pyclass_type
                typecode = self
                def __init__(self):
                    # pyclass
                    self._bytes = None
                    self._id = None
                    self._issuer = None
                    self._notAfter = None
                    self._subject = None
                    return
                def __repr__(self):
                    return "%s, %s" % (self._subject, self._issuer)
            Holder.__name__ = "X509Certificate_Holder"
            self.pyclass = Holder

    class ArrayOfX509Certificate_Def(ZSI.TC.Array, TypeDefinition):
        #complexType/complexContent base="SOAP-ENC:Array"
        schema = "http://glite.org/wsdl/services/org.glite.security.voms.service.certificates"
        type = (schema, "ArrayOfX509Certificate")
        def __init__(self, pname, ofwhat=(), extend=False, restrict=False, attributes=None, **kw):
            ofwhat = ns0.X509Certificate_Def(None, typed=False)
            atype = (u'http://glite.org/wsdl/services/org.glite.security.voms.service.certificates', u'X509Certificate[]')
            ZSI.TCcompound.Array.__init__(self, atype, ofwhat, pname=pname, childnames='item', **kw)

# end class ns0 (tns: http://glite.org/wsdl/services/org.glite.security.voms.service.certificates)
