#
# Copyright (c) Members of the EGEE Collaboration. 2006-2009.
# See http://www.eu-egee.org/partners/ for details on the copyright holders.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Authors:
# 	Andrea Ceccanti (INFN)
#

################################################## 
# VOMSCertificatesService_services.py 
# generated by ZSI.generate.wsdl2python
##################################################


from VOMSCertificatesService_services_types import *
import urlparse, types
from ZSI.TCcompound import ComplexType, Struct
from ZSI import client
import ZSI
from ZSI.generate.pyclass import pyclass_type
from CertificatesFix import *

# Locator
class VOMSCertificatesServiceLocator:
    VOMSCertificates_address = "https://localhost:8443/voms/infngrid/services/VOMSCertificates"
    def getVOMSCertificatesAddress(self):
        return VOMSCertificatesServiceLocator.VOMSCertificates_address
    def getVOMSCertificates(self, url=None, **kw):
        return VOMSCertificatesSoapBindingSOAP(url or VOMSCertificatesServiceLocator.VOMSCertificates_address, **kw)

# Methods
class VOMSCertificatesSoapBindingSOAP:
    
    def __init__(self, url, **kw):
        kw.setdefault("readerclass", None)
        kw.setdefault("writerclass", None)
        # no resource properties
        self.binding = client.Binding(url=url, **kw)
        # no ws-addressing
        
    
    # op: getCertificates
    def getCertificates(self, request):
        if isinstance(request, getCertificatesRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getCertificatesResponse.typecode.ofwhat, pyclass=getCertificatesResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: addCertificate
    def addCertificate(self, request):
        if isinstance(request, addCertificateRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=addCertificateResponse.typecode.ofwhat, pyclass=addCertificateResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response
    
    
    # op: addCertificate
    def restoreCertificate(self, request):
        if isinstance(request, restoreCertificateRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=restoreCertificateResponse.typecode.ofwhat, pyclass=restoreCertificateResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: removeCertificate
    def removeCertificate(self, request):
        if isinstance(request, removeCertificateRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=removeCertificateResponse.typecode.ofwhat, pyclass=removeCertificateResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    
    # op: suspendCertificate
    def suspendCertificate(self, request):
        if isinstance(request, suspendCertificateRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=suspendCertificateResponse.typecode.ofwhat, pyclass=suspendCertificateResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: getUserIdFromDn
    def getUserIdFromDn(self, request):
        if isinstance(request, getUserIdFromDnRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getUserIdFromDnResponse.typecode.ofwhat, pyclass=getUserIdFromDnResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response


_removeCertificateRequestTypecode = Struct(pname=("http://service.admin.voms.security.glite.org","removeCertificate"), ofwhat=[ns0.X509Certificate_Def(pname="cert", aname="_cert", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=None, encoded="http://service.admin.voms.security.glite.org")
class removeCertificateRequest:
    typecode = _removeCertificateRequestTypecode
    __metaclass__ = pyclass_type
    def __init__(self):
        self._cert = None
        return
removeCertificateRequest.typecode.pyclass = removeCertificateRequest

_removeCertificateResponseTypecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.certificates","removeCertificateResponse"), ofwhat=[], pyclass=None, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.certificates")
class removeCertificateResponse:
    typecode = _removeCertificateResponseTypecode
    __metaclass__ = pyclass_type
    def __init__(self):
        return
removeCertificateResponse.typecode.pyclass = removeCertificateResponse

_suspendCertificateRequestTypecode = Struct(pname=("http://service.admin.voms.security.glite.org","suspendCertificate"), ofwhat=[ns0.X509Certificate_Def(pname="cert", aname="_cert", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="reason", aname="_reason", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=None, encoded="http://service.admin.voms.security.glite.org")
class suspendCertificateRequest:
    typecode = _suspendCertificateRequestTypecode
    __metaclass__ = pyclass_type
    def __init__(self):
        self._cert = None
        self._reason = None
        return
suspendCertificateRequest.typecode.pyclass = suspendCertificateRequest

_suspendCertificateResponseTypecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.certificates","suspendCertificateResponse"), ofwhat=[], pyclass=None, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.certificates")
class suspendCertificateResponse:
    typecode = _suspendCertificateResponseTypecode
    __metaclass__ = pyclass_type
    def __init__(self):
        return
suspendCertificateResponse.typecode.pyclass = suspendCertificateResponse

_getUserIdFromDnRequestTypecode = Struct(pname=("http://service.admin.voms.security.glite.org","getUserIdFromDn"), ofwhat=[ZSI.TC.String(pname="subject", aname="_subject", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="issuer", aname="_issuer", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=None, encoded="http://service.admin.voms.security.glite.org")
class getUserIdFromDnRequest:
    typecode = _getUserIdFromDnRequestTypecode
    __metaclass__ = pyclass_type
    def __init__(self):
        self._subject = None
        self._issuer = None
        return
getUserIdFromDnRequest.typecode.pyclass = getUserIdFromDnRequest

_getUserIdFromDnResponseTypecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.certificates","getUserIdFromDnResponse"), ofwhat=[ZSI.TCnumbers.Ilong(pname="getUserIdFromDnReturn", aname="_getUserIdFromDnReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=None, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.certificates")
class getUserIdFromDnResponse:
    typecode = _getUserIdFromDnResponseTypecode
    __metaclass__ = pyclass_type
    def __init__(self):
        self._getUserIdFromDnReturn = None
        return
getUserIdFromDnResponse.typecode.pyclass = getUserIdFromDnResponse