#
# Copyright (c) Members of the EGEE Collaboration. 2006-2009.
# See http://www.eu-egee.org/partners/ for details on the copyright holders.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Authors:
# 	Andrea Ceccanti (INFN)
#

################################################## 
# VOMSAttributesService_services_types.py 
# generated by ZSI.generate.wsdl2python
##################################################


import ZSI
import ZSI.TCcompound
from ZSI.schema import LocalElementDeclaration, ElementDeclaration, TypeDefinition, GTD, GED

##############################
# targetNamespace
# http://glite.org/wsdl/services/org.glite.security.voms
##############################

class ns0:
    targetNamespace = "http://glite.org/wsdl/services/org.glite.security.voms"

    class VOMSException_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://glite.org/wsdl/services/org.glite.security.voms"
        type = (schema, "VOMSException")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.VOMSException_Def.schema
            TClist = []
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                typecode = self
                def __init__(self):
                    # pyclass
                    return
            Holder.__name__ = "VOMSException_Holder"
            self.pyclass = Holder

    class User_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://glite.org/wsdl/services/org.glite.security.voms"
        type = (schema, "User")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.User_Def.schema
            TClist = [ZSI.TC.String(pname="CA", aname="_CA", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="CN", aname="_CN", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="DN", aname="_DN", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="certUri", aname="_certUri", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="mail", aname="_mail", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                typecode = self
                def __init__(self):
                    # pyclass
                    self._CA = None
                    self._CN = None
                    self._DN = None
                    self._certUri = None
                    self._mail = None
                    return
            Holder.__name__ = "User_Holder"
            self.pyclass = Holder

# end class ns0 (tns: http://glite.org/wsdl/services/org.glite.security.voms)

##############################
# targetNamespace
# http://glite.org/wsdl/services/org.glite.security.voms.service.attributes
##############################

class ns1:
    targetNamespace = "http://glite.org/wsdl/services/org.glite.security.voms.service.attributes"

    class AttributeClass_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://glite.org/wsdl/services/org.glite.security.voms.service.attributes"
        type = (schema, "AttributeClass")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns1.AttributeClass_Def.schema
            TClist = [ZSI.TC.String(pname="description", aname="_description", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="name", aname="_name", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.Boolean(pname="uniquenessChecked", aname="_uniquenessChecked", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                typecode = self
                def __init__(self):
                    # pyclass
                    self._description = None
                    self._name = None
                    self._uniquenessChecked = None
                    return
                
                def __repr__(self):
                    desc = "%s\t\t(unique= %s, description=%s) " % (self._name, self._uniquenessChecked, self._description)
                    
                    return desc
            Holder.__name__ = "AttributeClass_Holder"
            self.pyclass = Holder

    class ArrayOfAttributeClass_Def(ZSI.TC.Array, TypeDefinition):
        #complexType/complexContent base="SOAP-ENC:Array"
        schema = "http://glite.org/wsdl/services/org.glite.security.voms.service.attributes"
        type = (schema, "ArrayOfAttributeClass")
        def __init__(self, pname, ofwhat=(), extend=False, restrict=False, attributes=None, **kw):
            ofwhat = ns1.AttributeClass_Def(None, typed=False)
            atype = (u'http://glite.org/wsdl/services/org.glite.security.voms.service.attributes', u'AttributeClass[]')
            ZSI.TCcompound.Array.__init__(self, atype, ofwhat, pname=pname, childnames='item', **kw)

    class AttributeValue_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://glite.org/wsdl/services/org.glite.security.voms.service.attributes"
        type = (schema, "AttributeValue")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns1.AttributeValue_Def.schema
            TClist = [GTD("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","AttributeClass",lazy=False)(pname="attributeClass", aname="_attributeClass", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="context", aname="_context", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="value", aname="_value", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                typecode = self
                def __init__(self):
                    # pyclass
                    self._attributeClass = None
                    self._context = None
                    self._value = None
                    return
                def __repr__(self):
                    return "%s=%s" % (self._attributeClass._name, self._value) 
            Holder.__name__ = "AttributeValue_Holder"
            self.pyclass = Holder

    class ArrayOfAttributeValue_Def(ZSI.TC.Array, TypeDefinition):
        #complexType/complexContent base="SOAP-ENC:Array"
        schema = "http://glite.org/wsdl/services/org.glite.security.voms.service.attributes"
        type = (schema, "ArrayOfAttributeValue")
        def __init__(self, pname, ofwhat=(), extend=False, restrict=False, attributes=None, **kw):
            ofwhat = ns1.AttributeValue_Def(None, typed=False)
            atype = (u'http://glite.org/wsdl/services/org.glite.security.voms.service.attributes', u'AttributeValue[]')
            ZSI.TCcompound.Array.__init__(self, atype, ofwhat, pname=pname, childnames='item', **kw)

# end class ns1 (tns: http://glite.org/wsdl/services/org.glite.security.voms.service.attributes)
