#
# Copyright (c) Members of the EGEE Collaboration. 2006-2009.
# See http://www.eu-egee.org/partners/ for details on the copyright holders.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Authors:
# 	Andrea Ceccanti (INFN)
#

################################################## 
# VOMSAttributesService_services.py 
# generated by ZSI.generate.wsdl2python
##################################################


from VOMSAttributesService_services_types import *
import urlparse, types
from ZSI.TCcompound import ComplexType, Struct
from ZSI import client
import ZSI
import AttributesFix

# Locator
class VOMSAttributesServiceLocator:
    VOMSAttributes_address = "https://localhost:8443/glite-security-voms-admin-interface/VOMSAttributes"
    def getVOMSAttributesAddress(self):
        return VOMSAttributesServiceLocator.VOMSAttributes_address
    def getVOMSAttributes(self, url=None, **kw):
        return VOMSAttributesSoapBindingSOAP(url or VOMSAttributesServiceLocator.VOMSAttributes_address, **kw)

# Methods
class VOMSAttributesSoapBindingSOAP:
    def __init__(self, url, **kw):
        kw.setdefault("readerclass", None)
        kw.setdefault("writerclass", None)
        # no resource properties
        self.binding = client.Binding(url=url, **kw)
        # no ws-addressing

    # op: createAttributeClass
    def createAttributeClass(self, request):
        if isinstance(request, AttributesFix.createAttributeClassRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=AttributesFix.createAttributeClassResponse.typecode.ofwhat, pyclass=AttributesFix.createAttributeClassResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: getAttributeClass
    def getAttributeClass(self, request):
        if isinstance(request, getAttributeClassRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getAttributeClassResponse.typecode.ofwhat, pyclass=getAttributeClassResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: saveAttributeClass
    def saveAttributeClass(self, request):
        if isinstance(request, saveAttributeClassRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=saveAttributeClassResponse.typecode.ofwhat, pyclass=saveAttributeClassResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: deleteAttributeClass
    def deleteAttributeClass(self, request):
        if isinstance(request, AttributesFix.deleteAttributeClassRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=AttributesFix.deleteAttributeClassResponse.typecode.ofwhat, pyclass=AttributesFix.deleteAttributeClassResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response


    # op: listAttributeClasses
    def listAttributeClasses(self, request):
        if isinstance(request, listAttributeClassesRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=listAttributeClassesResponse.typecode.ofwhat, pyclass=listAttributeClassesResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: listUserAttributes
    def listUserAttributes(self, request):
        if isinstance(request, listUserAttributesRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=listUserAttributesResponse.typecode.ofwhat, pyclass=listUserAttributesResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: setUserAttribute
    def setUserAttribute(self, request):
        if isinstance(request, setUserAttributeRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=setUserAttributeResponse.typecode.ofwhat, pyclass=setUserAttributeResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: deleteUserAttribute
    def deleteUserAttribute(self, request):
        if isinstance(request, AttributesFix.deleteUserAttributeRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=AttributesFix.deleteUserAttributeResponse.typecode.ofwhat, pyclass=AttributesFix.deleteUserAttributeResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: setGroupAttribute
    def setGroupAttribute(self, request):
        if isinstance(request, setGroupAttributeRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=setGroupAttributeResponse.typecode.ofwhat, pyclass=setGroupAttributeResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: deleteGroupAttribute
    def deleteGroupAttribute(self, request):
        if isinstance(request, deleteGroupAttributeRequest1) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=deleteGroupAttributeResponse1.typecode.ofwhat, pyclass=deleteGroupAttributeResponse1.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: listGroupAttributes
    def listGroupAttributes(self, request):
        if isinstance(request, listGroupAttributesRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=listGroupAttributesResponse.typecode.ofwhat, pyclass=listGroupAttributesResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: setRoleAttribute
    def setRoleAttribute(self, request):
        if isinstance(request, setRoleAttributeRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=setRoleAttributeResponse.typecode.ofwhat, pyclass=setRoleAttributeResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: deleteRoleAttribute
    def deleteRoleAttribute(self, request):
        if isinstance(request, deleteRoleAttributeRequest1) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=deleteRoleAttributeResponse1.typecode.ofwhat, pyclass=deleteRoleAttributeResponse1.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: listRoleAttributes
    def listRoleAttributes(self, request):
        if isinstance(request, listRoleAttributesRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=listRoleAttributesResponse.typecode.ofwhat, pyclass=listRoleAttributesResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

class createAttributeClassRequest2:
    def __init__(self):
        self._in0 = None
        return
createAttributeClassRequest2.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","createAttributeClass"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=createAttributeClassRequest2, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class createAttributeClassResponse2:
    def __init__(self):
        return
createAttributeClassResponse2.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","createAttributeClassResponse"), ofwhat=[], pyclass=createAttributeClassResponse2, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")



class getAttributeClassRequest:
    def __init__(self):
        self._in0 = None
        return
getAttributeClassRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","getAttributeClass"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getAttributeClassRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class getAttributeClassResponse:
    def __init__(self):
        self._getAttributeClassReturn = None
        return
getAttributeClassResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","getAttributeClassResponse"), ofwhat=[ns1.AttributeClass_Def(pname="getAttributeClassReturn", aname="_getAttributeClassReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getAttributeClassResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class saveAttributeClassRequest:
    def __init__(self):
        self._in0 = None
        return
saveAttributeClassRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","saveAttributeClass"), ofwhat=[ns1.AttributeClass_Def(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=saveAttributeClassRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class saveAttributeClassResponse:
    def __init__(self):
        return
saveAttributeClassResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","saveAttributeClassResponse"), ofwhat=[], pyclass=saveAttributeClassResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class deleteAttributeClassRequest1:
    def __init__(self):
        self._in0 = None
        return
deleteAttributeClassRequest1.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","deleteAttributeClass"), ofwhat=[ns1.AttributeClass_Def(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=deleteAttributeClassRequest1, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class deleteAttributeClassResponse1:
    def __init__(self):
        return
deleteAttributeClassResponse1.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","deleteAttributeClassResponse"), ofwhat=[], pyclass=deleteAttributeClassResponse1, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class listAttributeClassesRequest:
    def __init__(self):
        return
listAttributeClassesRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","listAttributeClasses"), ofwhat=[], pyclass=listAttributeClassesRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class listAttributeClassesResponse:
    def __init__(self):
        self._listAttributeClassesReturn = None
        return
listAttributeClassesResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","listAttributeClassesResponse"), ofwhat=[ns1.ArrayOfAttributeClass_Def(pname="listAttributeClassesReturn", aname="_listAttributeClassesReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listAttributeClassesResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class listUserAttributesRequest:
    def __init__(self):
        self._in0 = None
        return
listUserAttributesRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","listUserAttributes"), ofwhat=[ns0.User_Def(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listUserAttributesRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class listUserAttributesResponse:
    def __init__(self):
        self._listUserAttributesReturn = None
        return
listUserAttributesResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","listUserAttributesResponse"), ofwhat=[ns1.ArrayOfAttributeValue_Def(pname="listUserAttributesReturn", aname="_listUserAttributesReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listUserAttributesResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class setUserAttributeRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
setUserAttributeRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","setUserAttribute"), ofwhat=[ns0.User_Def(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns1.AttributeValue_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=setUserAttributeRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class setUserAttributeResponse:
    def __init__(self):
        return
setUserAttributeResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","setUserAttributeResponse"), ofwhat=[], pyclass=setUserAttributeResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class deleteUserAttributeRequest1:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
deleteUserAttributeRequest1.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","deleteUserAttribute"), ofwhat=[ns0.User_Def(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns1.AttributeValue_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=deleteUserAttributeRequest1, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class deleteUserAttributeResponse1:
    def __init__(self):
        return
deleteUserAttributeResponse1.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","deleteUserAttributeResponse"), ofwhat=[], pyclass=deleteUserAttributeResponse1, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class setGroupAttributeRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
setGroupAttributeRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","setGroupAttribute"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns1.AttributeValue_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=setGroupAttributeRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class setGroupAttributeResponse:
    def __init__(self):
        return
setGroupAttributeResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","setGroupAttributeResponse"), ofwhat=[], pyclass=setGroupAttributeResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class deleteGroupAttributeRequest1:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
deleteGroupAttributeRequest1.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","deleteGroupAttribute"), 
                                               ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), 
                                                       ns1.AttributeValue_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], 
                                               pyclass=deleteGroupAttributeRequest1, 
                                               encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class deleteGroupAttributeResponse1:
    def __init__(self):
        return
deleteGroupAttributeResponse1.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","deleteGroupAttributeResponse"), ofwhat=[], pyclass=deleteGroupAttributeResponse1, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class listGroupAttributesRequest:
    def __init__(self):
        self._in0 = None
        return
listGroupAttributesRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","listGroupAttributes"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listGroupAttributesRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class listGroupAttributesResponse:
    def __init__(self):
        self._listGroupAttributesReturn = None
        return
listGroupAttributesResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","listGroupAttributesResponse"), ofwhat=[ns1.ArrayOfAttributeValue_Def(pname="listGroupAttributesReturn", aname="_listGroupAttributesReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listGroupAttributesResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class setRoleAttributeRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        self._in2 = None
        return
setRoleAttributeRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","setRoleAttribute"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns1.AttributeValue_Def(pname="in2", aname="_in2", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=setRoleAttributeRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class setRoleAttributeResponse:
    def __init__(self):
        return
setRoleAttributeResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","setRoleAttributeResponse"), ofwhat=[], pyclass=setRoleAttributeResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class deleteRoleAttributeRequest1:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        self._in2 = None
        return
deleteRoleAttributeRequest1.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","deleteRoleAttribute"), 
                                              ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), 
                                                      ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), 
                                                      ns1.AttributeValue_Def(pname="in2", aname="_in2", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], 
                                              pyclass=deleteRoleAttributeRequest1, 
                                              encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class deleteRoleAttributeResponse1:
    def __init__(self):
        return
deleteRoleAttributeResponse1.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","deleteRoleAttributeResponse"), ofwhat=[], pyclass=deleteRoleAttributeResponse1, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class listRoleAttributesRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
listRoleAttributesRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","listRoleAttributes"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listRoleAttributesRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")

class listRoleAttributesResponse:
    def __init__(self):
        self._listRoleAttributesReturn = None
        return
listRoleAttributesResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.attributes","listRoleAttributesResponse"), ofwhat=[ns1.ArrayOfAttributeValue_Def(pname="listRoleAttributesReturn", aname="_listRoleAttributesReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listRoleAttributesResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.attributes")
