#
# Copyright (c) Members of the EGEE Collaboration. 2006-2009.
# See http://www.eu-egee.org/partners/ for details on the copyright holders.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Authors:
# 	Andrea Ceccanti (INFN)
#

################################################## 
# VOMSAdminService_services_types.py 
# generated by ZSI.generate.wsdl2python
##################################################


import ZSI
import ZSI.TCcompound
from ZSI.schema import LocalElementDeclaration, ElementDeclaration, TypeDefinition, GTD, GED

##############################
# targetNamespace
# http://glite.org/wsdl/services/org.glite.security.voms
##############################

class ns0:
    targetNamespace = "http://glite.org/wsdl/services/org.glite.security.voms"

    class User_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://glite.org/wsdl/services/org.glite.security.voms"
        type = (schema, "User")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.User_Def.schema
            TClist = [ZSI.TC.String(pname="CA", aname="_CA", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="CN", aname="_CN", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="DN", aname="_DN", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="certUri", aname="_certUri", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="mail", aname="_mail", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                typecode = self
                def __init__(self):
                    # pyclass
                    self._CA = None
                    self._CN = None
                    self._DN = None
                    self._certUri = None
                    self._mail = None
                    return
                
                def __repr__(self):
                                        
                    return "%s,%s,%s" % (self._DN, self._CA,self._mail)
                
            
            Holder.__name__ = "User_Holder"
            self.pyclass = Holder

    class VOMSException_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://glite.org/wsdl/services/org.glite.security.voms"
        type = (schema, "VOMSException")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.VOMSException_Def.schema
            TClist = []
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                typecode = self
                def __init__(self):
                    # pyclass
                    return
            Holder.__name__ = "VOMSException_Holder"
            self.pyclass = Holder

    class ACLEntry_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://glite.org/wsdl/services/org.glite.security.voms"
        type = (schema, "ACLEntry")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns0.ACLEntry_Def.schema
            TClist = [ZSI.TC.String(pname="adminCA", aname="_adminCA", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="adminDN", aname="_adminDN", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.Boolean(pname="allow", aname="_allow", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="operationName", aname="_operationName", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                typecode = self
                def __init__(self):
                    # pyclass
                    self._adminCA = None
                    self._adminDN = None
                    self._allow = None
                    self._operationName = None
                    return
            Holder.__name__ = "ACLEntry_Holder"
            self.pyclass = Holder

# end class ns0 (tns: http://glite.org/wsdl/services/org.glite.security.voms)

##############################
# targetNamespace
# http://glite.org/wsdl/services/org.glite.security.voms.service.admin
##############################

class ns1:
    targetNamespace = "http://glite.org/wsdl/services/org.glite.security.voms.service.admin"

    class ArrayOf_tns2_User_Def(ZSI.TC.Array, TypeDefinition):
        #complexType/complexContent base="SOAP-ENC:Array"
        schema = "http://glite.org/wsdl/services/org.glite.security.voms.service.admin"
        type = (schema, "ArrayOf_tns2_User")
        def __init__(self, pname, ofwhat=(), extend=False, restrict=False, attributes=None, **kw):
            ofwhat = ns0.User_Def(None, typed=False)
            atype = (u'http://glite.org/wsdl/services/org.glite.security.voms', u'User[]')
            ZSI.TCcompound.Array.__init__(self, atype, ofwhat, pname=pname, childnames='item', **kw)

    class ArrayOf_soapenc_string_Def(ZSI.TC.Array, TypeDefinition):
        #complexType/complexContent base="SOAP-ENC:Array"
        schema = "http://glite.org/wsdl/services/org.glite.security.voms.service.admin"
        type = (schema, "ArrayOf_soapenc_string")
        def __init__(self, pname, ofwhat=(), extend=False, restrict=False, attributes=None, **kw):
            ofwhat = ZSI.TC.String(None, typed=False)
            atype = (u'http://schemas.xmlsoap.org/soap/encoding/', u'string[]')
            ZSI.TCcompound.Array.__init__(self, atype, ofwhat, pname=pname, childnames='item', **kw)

    class ArrayOf_tns2_ACLEntry_Def(ZSI.TC.Array, TypeDefinition):
        #complexType/complexContent base="SOAP-ENC:Array"
        schema = "http://glite.org/wsdl/services/org.glite.security.voms.service.admin"
        type = (schema, "ArrayOf_tns2_ACLEntry")
        def __init__(self, pname, ofwhat=(), extend=False, restrict=False, attributes=None, **kw):
            ofwhat = ns0.ACLEntry_Def(None, typed=False)
            atype = (u'http://glite.org/wsdl/services/org.glite.security.voms', u'ACLEntry[]')
            ZSI.TCcompound.Array.__init__(self, atype, ofwhat, pname=pname, childnames='item', **kw)

# end class ns1 (tns: http://glite.org/wsdl/services/org.glite.security.voms.service.admin)
