#
# Copyright (c) Members of the EGEE Collaboration. 2006-2009.
# See http://www.eu-egee.org/partners/ for details on the copyright holders.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Authors:
# 	Andrea Ceccanti (INFN)
#

################################################## 
# VOMSAdminService_services.py 
# generated by ZSI.generate.wsdl2python
##################################################


from VOMSAdminService_services_types import *
import urlparse, types
from ZSI.TCcompound import ComplexType, Struct
from ZSI import client
from ListRoleFix import *
import ZSI

# Locator
class VOMSAdminServiceLocator:
    VOMSAdmin_address = "https://localhost:8443/glite-security-voms-admin-interface/VOMSAdmin"
    def getVOMSAdminAddress(self):
        return VOMSAdminServiceLocator.VOMSAdmin_address
    def getVOMSAdmin(self, url=None, **kw):
        return VOMSAdminSoapBindingSOAP(url or VOMSAdminServiceLocator.VOMSAdmin_address, **kw)

# Methods
class VOMSAdminSoapBindingSOAP:
    def __init__(self, url, **kw):
        kw.setdefault("readerclass", None)
        kw.setdefault("writerclass", None)
        # no resource properties
        self.binding = client.Binding(url=url, **kw)
        # no ws-addressing

    # op: getUser
    def getUser(self, request):
        if isinstance(request, getUserRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getUserResponse.typecode.ofwhat, pyclass=getUserResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: setUser
    def setUser(self, request):
        if isinstance(request, setUserRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=setUserResponse.typecode.ofwhat, pyclass=setUserResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: getMajorVersionNumber
    def getMajorVersionNumber(self, request):
        if isinstance(request, getMajorVersionNumberRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getMajorVersionNumberResponse.typecode.ofwhat, pyclass=getMajorVersionNumberResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: getVOName
    def getVOName(self, request):
        if isinstance(request, getVONameRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getVONameResponse.typecode.ofwhat, pyclass=getVONameResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: createUser
    def createUser(self, request):
        if isinstance(request, createUserRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=createUserResponse.typecode.ofwhat, pyclass=createUserResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: deleteUser
    def deleteUser(self, request):
        if isinstance(request, deleteUserRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=deleteUserResponse.typecode.ofwhat, pyclass=deleteUserResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: deleteGroup
    def deleteGroup(self, request):
        if isinstance(request, deleteGroupRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=deleteGroupResponse.typecode.ofwhat, pyclass=deleteGroupResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: createRole
    def createRole(self, request):
        if isinstance(request, createRoleRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=createRoleResponse.typecode.ofwhat, pyclass=createRoleResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: deleteRole
    def deleteRole(self, request):
        if isinstance(request, deleteRoleRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=deleteRoleResponse.typecode.ofwhat, pyclass=deleteRoleResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: createCapability
    def createCapability(self, request):
        if isinstance(request, createCapabilityRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=createCapabilityResponse.typecode.ofwhat, pyclass=createCapabilityResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: deleteCapability
    def deleteCapability(self, request):
        if isinstance(request, deleteCapabilityRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=deleteCapabilityResponse.typecode.ofwhat, pyclass=deleteCapabilityResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: addMember
    def addMember(self, request):
        if isinstance(request, addMemberRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=addMemberResponse.typecode.ofwhat, pyclass=addMemberResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: removeMember
    def removeMember(self, request):
        if isinstance(request, removeMemberRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=removeMemberResponse.typecode.ofwhat, pyclass=removeMemberResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: assignRole
    def assignRole(self, request):
        if isinstance(request, assignRoleRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=assignRoleResponse.typecode.ofwhat, pyclass=assignRoleResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: dismissRole
    def dismissRole(self, request):
        if isinstance(request, dismissRoleRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=dismissRoleResponse.typecode.ofwhat, pyclass=dismissRoleResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: assignCapability
    def assignCapability(self, request):
        if isinstance(request, assignCapabilityRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=assignCapabilityResponse.typecode.ofwhat, pyclass=assignCapabilityResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: dismissCapability
    def dismissCapability(self, request):
        if isinstance(request, dismissCapabilityRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=dismissCapabilityResponse.typecode.ofwhat, pyclass=dismissCapabilityResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: listMembers
    def listMembers(self, request):
        if isinstance(request, listMembersRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=listMembersResponse.typecode.ofwhat, pyclass=listMembersResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: listUsersWithRole
    def listUsersWithRole(self, request):
        if isinstance(request, listUsersWithRoleRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=listUsersWithRoleResponse.typecode.ofwhat, pyclass=listUsersWithRoleResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: listUsersWithCapability
    def listUsersWithCapability(self, request):
        if isinstance(request, listUsersWithCapabilityRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=listUsersWithCapabilityResponse.typecode.ofwhat, pyclass=listUsersWithCapabilityResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: getGroupPath
    def getGroupPath(self, request):
        if isinstance(request, getGroupPathRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getGroupPathResponse.typecode.ofwhat, pyclass=getGroupPathResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: listSubGroups
    def listSubGroups(self, request):
        if isinstance(request, listSubGroupsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=listSubGroupsResponse.typecode.ofwhat, pyclass=listSubGroupsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: listGroups
    def listGroups(self, request):
        if isinstance(request, listGroupsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=listGroupsResponse.typecode.ofwhat, pyclass=listGroupsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: listRoles
    def listRoles(self, request):
        
        if isinstance(request, listRolesRequest1):
            kw = {}
            # no input wsaction
            self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
            # no output wsaction
            typecode = Struct(pname=None, ofwhat=listRolesResponse1.typecode.ofwhat, pyclass=listRolesResponse1.typecode.pyclass)
            response = self.binding.Receive(typecode)
            return response
        
        elif isinstance(request, listRolesRequest):
            kw = {}
            # no input wsaction
            self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
            # no output wsaction
            typecode = Struct(pname=None, ofwhat=listRolesResponse.typecode.ofwhat, pyclass=listRolesResponse1.typecode.pyclass)
            response = self.binding.Receive(typecode)
            return response
        else:
            raise TypeError, "%s incorrect request type" % (request.__class__)

    
    # op: listCapabilities
    def listCapabilities(self, request):
        if isinstance(request, listCapabilitiesRequest1) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=listCapabilitiesResponse1.typecode.ofwhat, pyclass=listCapabilitiesResponse1.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response


    # op: listCAs
    def listCAs(self, request):
        if isinstance(request, listCAsRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=listCAsResponse.typecode.ofwhat, pyclass=listCAsResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: getACL
    def getACL(self, request):
        if isinstance(request, getACLRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getACLResponse.typecode.ofwhat, pyclass=getACLResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: setACL
    def setACL(self, request):
        if isinstance(request, setACLRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=setACLResponse.typecode.ofwhat, pyclass=setACLResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: addACLEntry
    def addACLEntry(self, request):
        if isinstance(request, addACLEntryRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=addACLEntryResponse.typecode.ofwhat, pyclass=addACLEntryResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: removeACLEntry
    def removeACLEntry(self, request):
        if isinstance(request, removeACLEntryRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=removeACLEntryResponse.typecode.ofwhat, pyclass=removeACLEntryResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: getDefaultACL
    def getDefaultACL(self, request):
        if isinstance(request, getDefaultACLRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getDefaultACLResponse.typecode.ofwhat, pyclass=getDefaultACLResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: setDefaultACL
    def setDefaultACL(self, request):
        if isinstance(request, setDefaultACLRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=setDefaultACLResponse.typecode.ofwhat, pyclass=setDefaultACLResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: addDefaultACLEntry
    def addDefaultACLEntry(self, request):
        if isinstance(request, addDefaultACLEntryRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=addDefaultACLEntryResponse.typecode.ofwhat, pyclass=addDefaultACLEntryResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: removeDefaultACLEntry
    def removeDefaultACLEntry(self, request):
        if isinstance(request, removeDefaultACLEntryRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=removeDefaultACLEntryResponse.typecode.ofwhat, pyclass=removeDefaultACLEntryResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: getMinorVersionNumber
    def getMinorVersionNumber(self, request):
        if isinstance(request, getMinorVersionNumberRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getMinorVersionNumberResponse.typecode.ofwhat, pyclass=getMinorVersionNumberResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: getPatchVersionNumber
    def getPatchVersionNumber(self, request):
        if isinstance(request, getPatchVersionNumberRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getPatchVersionNumberResponse.typecode.ofwhat, pyclass=getPatchVersionNumberResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: createGroup
    def createGroup(self, request):
        if isinstance(request, createGroupRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=createGroupResponse.typecode.ofwhat, pyclass=createGroupResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

class getUserRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
getUserRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getUser"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getUserRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getUserResponse:
    def __init__(self):
        self._getUserReturn = None
        return
getUserResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getUserResponse"), ofwhat=[ns0.User_Def(pname="getUserReturn", aname="_getUserReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getUserResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class setUserRequest:
    def __init__(self):
        self._in0 = None
        return
setUserRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","setUser"), ofwhat=[ns0.User_Def(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=setUserRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class setUserResponse:
    def __init__(self):
        return
setUserResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","setUserResponse"), ofwhat=[], pyclass=setUserResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getMajorVersionNumberRequest:
    def __init__(self):
        return
getMajorVersionNumberRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getMajorVersionNumber"), ofwhat=[], pyclass=getMajorVersionNumberRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getMajorVersionNumberResponse:
    def __init__(self):
        self._getMajorVersionNumberReturn = None
        return
getMajorVersionNumberResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getMajorVersionNumberResponse"), ofwhat=[ZSI.TCnumbers.Iint(pname="getMajorVersionNumberReturn", aname="_getMajorVersionNumberReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getMajorVersionNumberResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getVONameRequest:
    def __init__(self):
        return
getVONameRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getVOName"), ofwhat=[], pyclass=getVONameRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getVONameResponse:
    def __init__(self):
        self._getVONameReturn = None
        return
getVONameResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getVONameResponse"), ofwhat=[ZSI.TC.String(pname="getVONameReturn", aname="_getVONameReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getVONameResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class createUserRequest:
    def __init__(self):
        self._in0 = None
        return
createUserRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","createUser"), ofwhat=[ns0.User_Def(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=createUserRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class createUserResponse:
    def __init__(self):
        return
createUserResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","createUserResponse"), ofwhat=[], pyclass=createUserResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class deleteUserRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
deleteUserRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","deleteUser"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=deleteUserRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class deleteUserResponse:
    def __init__(self):
        return
deleteUserResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","deleteUserResponse"), ofwhat=[], pyclass=deleteUserResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class deleteGroupRequest:
    def __init__(self):
        self._in0 = None
        return
deleteGroupRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","deleteGroup"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=deleteGroupRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class deleteGroupResponse:
    def __init__(self):
        return
deleteGroupResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","deleteGroupResponse"), ofwhat=[], pyclass=deleteGroupResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class createRoleRequest:
    def __init__(self):
        self._in0 = None
        return
createRoleRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","createRole"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=createRoleRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class createRoleResponse:
    def __init__(self):
        return
createRoleResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","createRoleResponse"), ofwhat=[], pyclass=createRoleResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class deleteRoleRequest:
    def __init__(self):
        self._in0 = None
        return
deleteRoleRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","deleteRole"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=deleteRoleRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class deleteRoleResponse:
    def __init__(self):
        return
deleteRoleResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","deleteRoleResponse"), ofwhat=[], pyclass=deleteRoleResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class createCapabilityRequest:
    def __init__(self):
        self._in0 = None
        return
createCapabilityRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","createCapability"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=createCapabilityRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class createCapabilityResponse:
    def __init__(self):
        return
createCapabilityResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","createCapabilityResponse"), ofwhat=[], pyclass=createCapabilityResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class deleteCapabilityRequest:
    def __init__(self):
        self._in0 = None
        return
deleteCapabilityRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","deleteCapability"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=deleteCapabilityRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class deleteCapabilityResponse:
    def __init__(self):
        return
deleteCapabilityResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","deleteCapabilityResponse"), ofwhat=[], pyclass=deleteCapabilityResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class addMemberRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        self._in2 = None
        return
addMemberRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","addMember"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in2", aname="_in2", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=addMemberRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class addMemberResponse:
    def __init__(self):
        return
addMemberResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","addMemberResponse"), ofwhat=[], pyclass=addMemberResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class removeMemberRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        self._in2 = None
        return
removeMemberRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","removeMember"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in2", aname="_in2", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=removeMemberRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class removeMemberResponse:
    def __init__(self):
        return
removeMemberResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","removeMemberResponse"), ofwhat=[], pyclass=removeMemberResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class assignRoleRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        self._in2 = None
        self._in3 = None
        return
assignRoleRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","assignRole"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in2", aname="_in2", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in3", aname="_in3", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=assignRoleRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class assignRoleResponse:
    def __init__(self):
        return
assignRoleResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","assignRoleResponse"), ofwhat=[], pyclass=assignRoleResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class dismissRoleRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        self._in2 = None
        self._in3 = None
        return
dismissRoleRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","dismissRole"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in2", aname="_in2", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in3", aname="_in3", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=dismissRoleRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class dismissRoleResponse:
    def __init__(self):
        return
dismissRoleResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","dismissRoleResponse"), ofwhat=[], pyclass=dismissRoleResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class assignCapabilityRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        self._in2 = None
        return
assignCapabilityRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","assignCapability"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in2", aname="_in2", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=assignCapabilityRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class assignCapabilityResponse:
    def __init__(self):
        return
assignCapabilityResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","assignCapabilityResponse"), ofwhat=[], pyclass=assignCapabilityResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class dismissCapabilityRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        self._in2 = None
        return
dismissCapabilityRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","dismissCapability"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in2", aname="_in2", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=dismissCapabilityRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class dismissCapabilityResponse:
    def __init__(self):
        return
dismissCapabilityResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","dismissCapabilityResponse"), ofwhat=[], pyclass=dismissCapabilityResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listMembersRequest:
    def __init__(self):
        self._in0 = None
        return
listMembersRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listMembers"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listMembersRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listMembersResponse:
    def __init__(self):
        self._listMembersReturn = None
        return
listMembersResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listMembersResponse"), ofwhat=[ns1.ArrayOf_tns2_User_Def(pname="listMembersReturn", aname="_listMembersReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listMembersResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listUsersWithRoleRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
listUsersWithRoleRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listUsersWithRole"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listUsersWithRoleRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listUsersWithRoleResponse:
    def __init__(self):
        self._listUsersWithRoleReturn = None
        return
listUsersWithRoleResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listUsersWithRoleResponse"), ofwhat=[ns1.ArrayOf_tns2_User_Def(pname="listUsersWithRoleReturn", aname="_listUsersWithRoleReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listUsersWithRoleResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listUsersWithCapabilityRequest:
    def __init__(self):
        self._in0 = None
        return
listUsersWithCapabilityRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listUsersWithCapability"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listUsersWithCapabilityRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listUsersWithCapabilityResponse:
    def __init__(self):
        self._listUsersWithCapabilityReturn = None
        return
listUsersWithCapabilityResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listUsersWithCapabilityResponse"), ofwhat=[ns1.ArrayOf_tns2_User_Def(pname="listUsersWithCapabilityReturn", aname="_listUsersWithCapabilityReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listUsersWithCapabilityResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getGroupPathRequest:
    def __init__(self):
        self._in0 = None
        return
getGroupPathRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getGroupPath"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getGroupPathRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getGroupPathResponse:
    def __init__(self):
        self._getGroupPathReturn = None
        return
getGroupPathResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getGroupPathResponse"), ofwhat=[ns1.ArrayOf_soapenc_string_Def(pname="getGroupPathReturn", aname="_getGroupPathReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getGroupPathResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listSubGroupsRequest:
    def __init__(self):
        self._in0 = None
        return
listSubGroupsRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listSubGroups"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listSubGroupsRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listSubGroupsResponse:
    def __init__(self):
        self._listSubGroupsReturn = None
        return
listSubGroupsResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listSubGroupsResponse"), ofwhat=[ns1.ArrayOf_soapenc_string_Def(pname="listSubGroupsReturn", aname="_listSubGroupsReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listSubGroupsResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listGroupsRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
listGroupsRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listGroups"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listGroupsRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listGroupsResponse:
    def __init__(self):
        self._listGroupsReturn = None
        return
listGroupsResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listGroupsResponse"), ofwhat=[ns1.ArrayOf_soapenc_string_Def(pname="listGroupsReturn", aname="_listGroupsReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listGroupsResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listRolesRequest1:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
listRolesRequest1.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listRoles"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listRolesRequest1, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listRolesResponse1:
    def __init__(self):
        self._listRolesReturn = None
        return
listRolesResponse1.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listRolesResponse"), ofwhat=[ns1.ArrayOf_soapenc_string_Def(pname="listRolesReturn", aname="_listRolesReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listRolesResponse1, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")



class listCapabilitiesRequest1:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
listCapabilitiesRequest1.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listCapabilities"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listCapabilitiesRequest1, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listCapabilitiesResponse1:
    def __init__(self):
        self._listCapabilitiesReturn = None
        return
listCapabilitiesResponse1.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listCapabilitiesResponse"), ofwhat=[ns1.ArrayOf_soapenc_string_Def(pname="listCapabilitiesReturn", aname="_listCapabilitiesReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listCapabilitiesResponse1, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listCAsRequest:
    def __init__(self):
        return
listCAsRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listCAs"), ofwhat=[], pyclass=listCAsRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class listCAsResponse:
    def __init__(self):
        self._listCAsReturn = None
        return
listCAsResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","listCAsResponse"), ofwhat=[ns1.ArrayOf_soapenc_string_Def(pname="listCAsReturn", aname="_listCAsReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=listCAsResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getACLRequest:
    def __init__(self):
        self._in0 = None
        return
getACLRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getACL"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getACLRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getACLResponse:
    def __init__(self):
        self._getACLReturn = None
        return
getACLResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getACLResponse"), ofwhat=[ns1.ArrayOf_tns2_ACLEntry_Def(pname="getACLReturn", aname="_getACLReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getACLResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class setACLRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
setACLRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","setACL"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns1.ArrayOf_tns2_ACLEntry_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=setACLRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class setACLResponse:
    def __init__(self):
        return
setACLResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","setACLResponse"), ofwhat=[], pyclass=setACLResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class addACLEntryRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
addACLEntryRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","addACLEntry"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ACLEntry_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=addACLEntryRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class addACLEntryResponse:
    def __init__(self):
        return
addACLEntryResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","addACLEntryResponse"), ofwhat=[], pyclass=addACLEntryResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class removeACLEntryRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
removeACLEntryRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","removeACLEntry"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ACLEntry_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=removeACLEntryRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class removeACLEntryResponse:
    def __init__(self):
        return
removeACLEntryResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","removeACLEntryResponse"), ofwhat=[], pyclass=removeACLEntryResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getDefaultACLRequest:
    def __init__(self):
        self._in0 = None
        return
getDefaultACLRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getDefaultACL"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getDefaultACLRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getDefaultACLResponse:
    def __init__(self):
        self._getDefaultACLReturn = None
        return
getDefaultACLResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getDefaultACLResponse"), ofwhat=[ns1.ArrayOf_tns2_ACLEntry_Def(pname="getDefaultACLReturn", aname="_getDefaultACLReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getDefaultACLResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class setDefaultACLRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
setDefaultACLRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","setDefaultACL"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns1.ArrayOf_tns2_ACLEntry_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=setDefaultACLRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class setDefaultACLResponse:
    def __init__(self):
        return
setDefaultACLResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","setDefaultACLResponse"), ofwhat=[], pyclass=setDefaultACLResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class addDefaultACLEntryRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
addDefaultACLEntryRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","addDefaultACLEntry"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ACLEntry_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=addDefaultACLEntryRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class addDefaultACLEntryResponse:
    def __init__(self):
        return
addDefaultACLEntryResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","addDefaultACLEntryResponse"), ofwhat=[], pyclass=addDefaultACLEntryResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class removeDefaultACLEntryRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
removeDefaultACLEntryRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","removeDefaultACLEntry"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns0.ACLEntry_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=removeDefaultACLEntryRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class removeDefaultACLEntryResponse:
    def __init__(self):
        return
removeDefaultACLEntryResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","removeDefaultACLEntryResponse"), ofwhat=[], pyclass=removeDefaultACLEntryResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getMinorVersionNumberRequest:
    def __init__(self):
        return
getMinorVersionNumberRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getMinorVersionNumber"), ofwhat=[], pyclass=getMinorVersionNumberRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getMinorVersionNumberResponse:
    def __init__(self):
        self._getMinorVersionNumberReturn = None
        return
getMinorVersionNumberResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getMinorVersionNumberResponse"), ofwhat=[ZSI.TCnumbers.Iint(pname="getMinorVersionNumberReturn", aname="_getMinorVersionNumberReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getMinorVersionNumberResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getPatchVersionNumberRequest:
    def __init__(self):
        return
getPatchVersionNumberRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getPatchVersionNumber"), ofwhat=[], pyclass=getPatchVersionNumberRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class getPatchVersionNumberResponse:
    def __init__(self):
        self._getPatchVersionNumberReturn = None
        return
getPatchVersionNumberResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","getPatchVersionNumberResponse"), ofwhat=[ZSI.TCnumbers.Iint(pname="getPatchVersionNumberReturn", aname="_getPatchVersionNumberReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getPatchVersionNumberResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class createGroupRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
createGroupRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","createGroup"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.String(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=createGroupRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")

class createGroupResponse:
    def __init__(self):
        return
createGroupResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.admin","createGroupResponse"), ofwhat=[], pyclass=createGroupResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.admin")
