#
# Copyright (c) Members of the EGEE Collaboration. 2006-2009.
# See http://www.eu-egee.org/partners/ for details on the copyright holders.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Authors:
# 	Andrea Ceccanti (INFN)
#

################################################## 
# VOMSACLService_services_types.py 
# generated by ZSI.generate.wsdl2python
##################################################


import ZSI
import ZSI.TCcompound
from ZSI.schema import LocalElementDeclaration, ElementDeclaration, TypeDefinition, GTD, GED

from VOMSPermission import VOMSPermission

##############################
# targetNamespace
# http://glite.org/wsdl/services/org.glite.security.voms
##############################

class ns1:
    targetNamespace = "http://glite.org/wsdl/services/org.glite.security.voms"

    class VOMSException_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://glite.org/wsdl/services/org.glite.security.voms"
        type = (schema, "VOMSException")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns1.VOMSException_Def.schema
            TClist = []
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                typecode = self
                def __init__(self):
                    # pyclass
                    return
            Holder.__name__ = "VOMSException_Holder"
            self.pyclass = Holder

# end class ns1 (tns: http://glite.org/wsdl/services/org.glite.security.voms)

##############################
# targetNamespace
# http://glite.org/wsdl/services/org.glite.security.voms.service.acl
##############################

class ns2:
    targetNamespace = "http://glite.org/wsdl/services/org.glite.security.voms.service.acl"

    class ACLEntry_Def(ZSI.TCcompound.ComplexType, TypeDefinition):
        schema = "http://glite.org/wsdl/services/org.glite.security.voms.service.acl"
        type = (schema, "ACLEntry")
        def __init__(self, pname, ofwhat=(), attributes=None, extend=False, restrict=False, **kw):
            ns = ns2.ACLEntry_Def.schema
            TClist = [ZSI.TC.String(pname="adminIssuer", aname="_adminIssuer", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TC.String(pname="adminSubject", aname="_adminSubject", minOccurs=1, maxOccurs=1, nillable=True, typed=False, encoded=kw.get("encoded")), ZSI.TCnumbers.Iint(pname="vomsPermissionBits", aname="_vomsPermissionBits", minOccurs=1, maxOccurs=1, nillable=False, typed=False, encoded=kw.get("encoded"))]
            self.attribute_typecode_dict = attributes or {}
            if extend: TClist += ofwhat
            if restrict: TClist = ofwhat
            ZSI.TCcompound.ComplexType.__init__(self, None, TClist, pname=pname, inorder=0, **kw)
            class Holder:
                typecode = self
                def __init__(self):
                    # pyclass
                    self._adminIssuer = None
                    self._adminSubject = None
                    self._vomsPermissionBits = None
		    return

		def __repr__(self):
                    return "(%s,%s): %s" % (self._adminSubject, self._adminIssuer, VOMSPermission(self._vomsPermissionBits))

            Holder.__name__ = "ACLEntry_Holder"
            self.pyclass = Holder

    class ArrayOfACLEntry_Def(ZSI.TC.Array, TypeDefinition):
        #complexType/complexContent base="SOAP-ENC:Array"
        schema = "http://glite.org/wsdl/services/org.glite.security.voms.service.acl"
        type = (schema, "ArrayOfACLEntry")
        def __init__(self, pname, ofwhat=(), extend=False, restrict=False, attributes=None, **kw):
            ofwhat = ns2.ACLEntry_Def(None, typed=False)
            atype = (u'http://glite.org/wsdl/services/org.glite.security.voms.service.acl', u'ACLEntry[]')
            ZSI.TCcompound.Array.__init__(self, atype, ofwhat, pname=pname, childnames='item', **kw)

# end class ns2 (tns: http://glite.org/wsdl/services/org.glite.security.voms.service.acl)
