#
# Copyright (c) Members of the EGEE Collaboration. 2006-2009.
# See http://www.eu-egee.org/partners/ for details on the copyright holders.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Authors:
# 	Andrea Ceccanti (INFN)
#

################################################## 
# VOMSACLService_services.py 
# generated by ZSI.generate.wsdl2python
##################################################


from VOMSACLService_services_types import *
import urlparse, types
from ZSI.TCcompound import ComplexType, Struct
from ZSI import client
import ZSI

# Locator
class VOMSACLServiceLocator:
    VOMSACL_address = "https://localhost:8443/glite-security-voms-admin-interface/VOMSACL"
    def getVOMSACLAddress(self):
        return VOMSACLServiceLocator.VOMSACL_address
    def getVOMSACL(self, url=None, **kw):
        return VOMSACLSoapBindingSOAP(url or VOMSACLServiceLocator.VOMSACL_address, **kw)

# Methods
class VOMSACLSoapBindingSOAP:
    def __init__(self, url, **kw):
        kw.setdefault("readerclass", None)
        kw.setdefault("writerclass", None)
        # no resource properties
        self.binding = client.Binding(url=url, **kw)
        # no ws-addressing

    # op: getACL
    def getACL(self, request):
        if isinstance(request, getACLRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getACLResponse.typecode.ofwhat, pyclass=getACLResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: setACL
    def setACL(self, request):
        if isinstance(request, setACLRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=setACLResponse.typecode.ofwhat, pyclass=setACLResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: addACLEntry
    def addACLEntry(self, request):
        if isinstance(request, addACLEntryRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=addACLEntryResponse.typecode.ofwhat, pyclass=addACLEntryResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: removeACLEntry
    def removeACLEntry(self, request):
        if isinstance(request, removeACLEntryRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=removeACLEntryResponse.typecode.ofwhat, pyclass=removeACLEntryResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: getDefaultACL
    def getDefaultACL(self, request):
        if isinstance(request, getDefaultACLRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=getDefaultACLResponse.typecode.ofwhat, pyclass=getDefaultACLResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: setDefaultACL
    def setDefaultACL(self, request):
        if isinstance(request, setDefaultACLRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=setDefaultACLResponse.typecode.ofwhat, pyclass=setDefaultACLResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: addDefaultACLEntry
    def addDefaultACLEntry(self, request):
        if isinstance(request, addDefaultACLEntryRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=addDefaultACLEntryResponse.typecode.ofwhat, pyclass=addDefaultACLEntryResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

    # op: removeDefaultACLEntry
    def removeDefaultACLEntry(self, request):
        if isinstance(request, removeDefaultACLEntryRequest) is False:
            raise TypeError, "%s incorrect request type" % (request.__class__)
        kw = {}
        # no input wsaction
        self.binding.Send(None, None, request, soapaction="", encodingStyle="http://schemas.xmlsoap.org/soap/encoding/", **kw)
        # no output wsaction
        typecode = Struct(pname=None, ofwhat=removeDefaultACLEntryResponse.typecode.ofwhat, pyclass=removeDefaultACLEntryResponse.typecode.pyclass)
        response = self.binding.Receive(typecode)
        return response

class getACLRequest:
    def __init__(self):
        self._in0 = None
        return
getACLRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","getACL"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getACLRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class getACLResponse:
    def __init__(self):
        self._getACLReturn = None
        return
getACLResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","getACLResponse"), ofwhat=[ns2.ArrayOfACLEntry_Def(pname="getACLReturn", aname="_getACLReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getACLResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class setACLRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
setACLRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","setACL"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns2.ArrayOfACLEntry_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=setACLRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class setACLResponse:
    def __init__(self):
        return
setACLResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","setACLResponse"), ofwhat=[], pyclass=setACLResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class addACLEntryRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        self._in2 = None
        return
addACLEntryRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","addACLEntry"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns2.ACLEntry_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.Boolean(pname="in2", aname="_in2", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=addACLEntryRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class addACLEntryResponse:
    def __init__(self):
        return
addACLEntryResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","addACLEntryResponse"), ofwhat=[], pyclass=addACLEntryResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class removeACLEntryRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        self._in2 = None
        return
removeACLEntryRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","removeACLEntry"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns2.ACLEntry_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ZSI.TC.Boolean(pname="in2", aname="_in2", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=removeACLEntryRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class removeACLEntryResponse:
    def __init__(self):
        return
removeACLEntryResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","removeACLEntryResponse"), ofwhat=[], pyclass=removeACLEntryResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class getDefaultACLRequest:
    def __init__(self):
        self._in0 = None
        return
getDefaultACLRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","getDefaultACL"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getDefaultACLRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class getDefaultACLResponse:
    def __init__(self):
        self._getDefaultACLReturn = None
        return
getDefaultACLResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","getDefaultACLResponse"), ofwhat=[ns2.ArrayOfACLEntry_Def(pname="getDefaultACLReturn", aname="_getDefaultACLReturn", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=getDefaultACLResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class setDefaultACLRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
setDefaultACLRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","setDefaultACL"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns2.ArrayOfACLEntry_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=setDefaultACLRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class setDefaultACLResponse:
    def __init__(self):
        return
setDefaultACLResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","setDefaultACLResponse"), ofwhat=[], pyclass=setDefaultACLResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class addDefaultACLEntryRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
addDefaultACLEntryRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","addDefaultACLEntry"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns2.ACLEntry_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=addDefaultACLEntryRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class addDefaultACLEntryResponse:
    def __init__(self):
        return
addDefaultACLEntryResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","addDefaultACLEntryResponse"), ofwhat=[], pyclass=addDefaultACLEntryResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class removeDefaultACLEntryRequest:
    def __init__(self):
        self._in0 = None
        self._in1 = None
        return
removeDefaultACLEntryRequest.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","removeDefaultACLEntry"), ofwhat=[ZSI.TC.String(pname="in0", aname="_in0", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True), ns2.ACLEntry_Def(pname="in1", aname="_in1", typed=False, encoded=None, minOccurs=1, maxOccurs=1, nillable=True)], pyclass=removeDefaultACLEntryRequest, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")

class removeDefaultACLEntryResponse:
    def __init__(self):
        return
removeDefaultACLEntryResponse.typecode = Struct(pname=("http://glite.org/wsdl/services/org.glite.security.voms.service.acl","removeDefaultACLEntryResponse"), ofwhat=[], pyclass=removeDefaultACLEntryResponse, encoded="http://glite.org/wsdl/services/org.glite.security.voms.service.acl")
