/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server.dynamic;

import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.server.dynamic.EvaluationContext;
import de.fzj.unicore.xuudb.server.dynamic.Mapping;
import de.fzj.unicore.xuudb.server.dynamic.MappingType;
import de.fzj.unicore.xuudb.server.dynamic.ProcessInvoker;
import de.fzj.unicore.xuudb.server.dynamic.SimplifiedCmdLineLexer;
import java.util.Arrays;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ScriptMapping
extends Mapping {
    public static final Logger log = Log.getLogger((String)"unicore.xuudb.server", ScriptMapping.class);
    public static final String ID = "script";
    private int timeout;

    public ScriptMapping(String configuration, MappingType maps, int timeout) {
        super(configuration, maps);
        this.timeout = timeout;
    }

    @Override
    public void applyAttributes(EvaluationContext context, boolean overwrite, boolean dryRun) {
        ProcessInvoker.TimeLimitedThread tlt;
        Object o;
        StandardEvaluationContext spCtx = new StandardEvaluationContext((Object)context);
        Expression expression = this.parseSpEL((ExpressionParser)new SpelExpressionParser(), this.getConfiguration(), (ParserContext)new TemplateParserContext("${", "}"));
        if (expression == null) {
            return;
        }
        try {
            o = expression.getValue((org.springframework.expression.EvaluationContext)spCtx);
        }
        catch (EvaluationException e) {
            log.warn((Object)("Script SpEL expression '" + expression.getExpressionString() + "' evaluation failed: " + e.getMessage()));
            return;
        }
        if (o == null) {
            log.warn((Object)("Script SpEL expression '" + expression.getExpressionString() + "' was evaluated to null"));
            return;
        }
        String cmdLine = o.toString();
        Object[] cmdLineTokens = SimplifiedCmdLineLexer.tokenizeString(cmdLine);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will run the following command line (comma is used to separate arguments):\n" + Arrays.toString(cmdLineTokens)));
        }
        ProcessInvoker invoker = new ProcessInvoker(this.timeout);
        try {
            tlt = invoker.invokeAndWait((String[])cmdLineTokens);
        }
        catch (Exception e) {
            Log.logException((String)("Execution of command line: " + Arrays.toString(cmdLineTokens) + " finished with an error: " + e.toString()), (Throwable)e, (Logger)log);
            return;
        }
        int exitCode = tlt.getP().exitValue();
        if (exitCode != 0) {
            log.warn((Object)("Mapping program '" + expression.getExpressionString() + "' finished with non-zero exit code " + exitCode + ", the stdErr was: " + tlt.getStderr()));
            return;
        }
        String returned = tlt.getStdout();
        log.debug((Object)("Got mapping for " + (Object)((Object)this.getType()) + ": '" + returned + "'"));
        if (returned != null) {
            returned = returned.trim();
        }
        if (returned == null || returned.length() == 0) {
            log.warn((Object)("Returned mapping is invalid (empty): '" + returned + "'"));
            return;
        }
        Object[] gids = null;
        if (this.getType() != MappingType.supplementaryGids) {
            if (returned.length() > 256 || !returned.matches("^[\\w]+$")) {
                log.warn((Object)("Returned mapping is invalid (invalid chars or too long): '" + returned + "'"));
                return;
            }
        } else {
            for (String string : gids = returned.split("[ ]+")) {
                if (string.length() <= 256 && string.matches("^[\\w]+$") && string.length() != 0) continue;
                log.warn((Object)("Returned mapping of supplementary gid is invalid (empty, invalid chars or too long): '" + string + "'"));
                return;
            }
        }
        switch (this.getType()) {
            case uid: {
                log.debug((Object)("Setting xlogin to: " + returned));
                context.setXlogin(returned);
                break;
            }
            case gid: {
                log.debug((Object)("Setting gid to: " + returned));
                context.setGid(returned);
                break;
            }
            case supplementaryGids: {
                if (overwrite) {
                    context.setSupplementaryGids(Arrays.asList(gids));
                    log.debug((Object)("Setting supplementary groups to: " + context.getSupplementaryGids()));
                    break;
                }
                Collections.addAll(context.getSupplementaryGids(), gids);
                log.debug((Object)("Adding the following supplementary groups: " + Arrays.toString(gids)));
            }
        }
    }

    private Expression parseSpEL(ExpressionParser spelParser, String expr, ParserContext parserCtx) {
        try {
            return parserCtx == null ? spelParser.parseExpression(expr) : spelParser.parseExpression(expr, parserCtx);
        }
        catch (ParseException e) {
            log.warn((Object)("Error parsing the SpEl expression: " + e.toDetailedString()));
            return null;
        }
        catch (Exception ee) {
            log.warn((Object)("Other problem parsing SpEL expression '" + expr + "': " + ee.toString()));
            return null;
        }
    }
}

