/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server.dynamic;

import de.fzj.unicore.xuudb.Log;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class ProcessInvoker {
    private static final Logger log = Log.getLogger((String)"unicore.xuudb.server", ProcessInvoker.class);
    public static final int MAX_TIMEOUT = 20000;
    private int maxTimeout = 20000;

    public ProcessInvoker() {
        this(20000);
    }

    public ProcessInvoker(int maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    public boolean invokeWithChecking(String toInvoke, String[] args) {
        Object[] cmdLine = new String[args.length + 1];
        cmdLine[0] = toInvoke;
        for (int i = 0; i < args.length; ++i) {
            cmdLine[i + 1] = args[i];
        }
        try {
            TimeLimitedThread tlt = this.invokeAndWait((String[])cmdLine);
            int exitStatus = tlt.getP().exitValue();
            if (exitStatus != 0) {
                log.error((Object)("Execution of command line: " + Arrays.toString(cmdLine) + " finished with a non-zero exit status: " + exitStatus + " StdErr is: " + tlt.getStderr()));
                return false;
            }
        }
        catch (Exception e) {
            Log.logException((String)("Execution of command line: " + Arrays.toString(cmdLine) + " finished with an error: " + e.toString()), (Throwable)e, (Logger)log);
            return false;
        }
        return true;
    }

    public Process invoke(String[] cmdLine) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(cmdLine);
        return process;
    }

    public TimeLimitedThread invokeAndWait(String[] cmdLine) throws Exception {
        Process process = this.invoke(cmdLine);
        TimeLimitedThread tlthread = new TimeLimitedThread(process);
        Thread thread = new Thread(tlthread);
        thread.start();
        this.waitFor(process, thread, tlthread, this.maxTimeout);
        return tlthread;
    }

    protected void waitFor(Process p, Thread thread, TimeLimitedThread tlthread, long timeout) throws Exception {
        try {
            thread.join(timeout);
            if (thread.isAlive()) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException e) {
            p.destroy();
            thread.interrupt();
            throw new Exception("Killed the invoked script as it hang for at least " + timeout + "ms");
        }
        if (tlthread.exc != null) {
            throw tlthread.exc;
        }
    }

    public static String readStdErrOut(InputStream is) {
        String msg;
        byte[] buf = new byte[1024];
        int i = 0;
        int r = 0;
        try {
            while ((r = is.read(buf, i, buf.length - i)) > 0) {
                i += r;
            }
            msg = new String(buf, 0, i, Charset.defaultCharset());
        }
        catch (IOException e) {
            msg = "Error reading the command's output.";
        }
        return msg;
    }

    protected boolean finished(Process p) {
        try {
            p.exitValue();
        }
        catch (IllegalThreadStateException ie) {
            return false;
        }
        return true;
    }

    protected static class TimeLimitedThread
    implements Runnable {
        protected Process p;
        protected String stderr;
        protected String stdout;
        protected Exception exc = null;

        public TimeLimitedThread(Process p) {
            this.p = p;
        }

        public void unsafeRun() throws Exception {
            this.stdout = ProcessInvoker.readStdErrOut(new BufferedInputStream(this.p.getInputStream()));
            this.stderr = ProcessInvoker.readStdErrOut(new BufferedInputStream(this.p.getErrorStream()));
            this.p.waitFor();
        }

        public Process getP() {
            return this.p;
        }

        public String getStderr() {
            return this.stderr;
        }

        public String getStdout() {
            return this.stdout;
        }

        public Exception getExc() {
            return this.exc;
        }

        @Override
        public void run() {
            try {
                this.unsafeRun();
            }
            catch (Exception e) {
                this.exc = e;
            }
        }
    }
}

