/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server.dynamic;

import de.fzJuelich.unicore.xuudb.SimplifiedAttributeType;
import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.server.db.IPoolStorage;
import de.fzj.unicore.xuudb.server.dynamic.EvaluationContext;
import de.fzj.unicore.xuudb.server.dynamic.Mapping;
import de.fzj.unicore.xuudb.server.dynamic.MappingType;
import de.fzj.unicore.xuudb.server.dynamic.Pool;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import org.apache.log4j.Logger;

public class PoolMapping
extends Mapping {
    public static final Logger log = Log.getLogger((String)"unicore.xuudb.server", PoolMapping.class);
    public static final String ID = "pool";
    private IPoolStorage storage;
    private Pool pool;

    public PoolMapping(Pool pool, IPoolStorage storage) {
        super(pool.getId(), pool.getType());
        this.storage = storage;
        this.pool = pool;
    }

    @Override
    public void applyAttributes(EvaluationContext context, boolean overwrite, boolean dryRun) {
        String dbKey = this.getKey(context);
        if (dbKey == null) {
            return;
        }
        String poolValue = this.storage.getOrCreateMapping(this.pool, dbKey, dryRun);
        if (poolValue == null) {
            log.warn((Object)("Pool " + this.pool.getId() + " is empty. The mapping is skipped."));
            return;
        }
        log.debug((Object)("Value of the key of type " + (Object)((Object)this.pool.getKeyType()) + " used by the pool " + this.pool.getId() + " is: " + poolValue));
        if (this.pool.getType().equals((Object)MappingType.uid)) {
            log.debug((Object)("Setting xlogin to " + poolValue));
            context.setXlogin(poolValue);
        } else if (this.pool.getType().equals((Object)MappingType.gid)) {
            log.debug((Object)("Setting gid to " + poolValue));
            context.setGid(poolValue);
        } else {
            throw new RuntimeException("Bug: pool configured with a type which is neither uid nor gid: " + (Object)((Object)this.pool.getType()));
        }
    }

    private String getKey(EvaluationContext context) {
        String key = null;
        switch (this.pool.getKeyType()) {
            case dn: {
                key = X500NameUtils.getComparableForm((String)context.getUserDN());
                break;
            }
            case issuer: {
                key = context.getIssuerDN();
                break;
            }
            case role: {
                key = context.getRole();
                break;
            }
            case vo: {
                key = context.getVo();
                break;
            }
            case generic: {
                for (SimplifiedAttributeType extra : context.getExtraAttributes()) {
                    if (!extra.getName().equals(this.pool.getGenericKey())) continue;
                    if (extra.getValueArray() != null && extra.getValueArray().length == 1) {
                        key = extra.getValueArray(0);
                        continue;
                    }
                    int numVals = extra.getValueArray() == null ? 0 : extra.getValueArray().length;
                    log.warn((Object)("Generic attribute " + extra.getName() + " which is used as a key for " + this.pool.getId() + " pool" + " has " + numVals + " values and should have exactly one. " + "Either it shouldn't be used as a key or your attribute " + "sources are misconfigured. The mapping is skipped."));
                    return null;
                }
                break;
            }
        }
        if (key == null || key.equals("")) {
            log.debug((Object)("Key of type " + (Object)((Object)this.pool.getKeyType()) + " used by pool " + this.pool.getId() + " is not available. The mapping is skipped."));
            return null;
        }
        log.debug((Object)("Key of type " + (Object)((Object)this.pool.getKeyType()) + " used by pool " + this.pool.getId() + " value is: " + key));
        return key;
    }
}

