/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server.dynamic;

import de.fzj.unicore.xuudb.server.dynamic.MappingType;
import de.fzj.unicore.xuudb.server.dynamic.PoolConfiguration;
import de.fzj.unicore.xuudb.server.dynamic.PoolKeyType;
import java.util.List;

public class Pool {
    protected int dbKey;
    protected String id;
    protected MappingType type;
    protected PoolKeyType keyType;
    protected String genericKey;
    protected boolean precreated;
    protected List<String> rawEntries;
    protected int realEntries;
    protected PoolConfiguration configuration;

    public Pool(String id, MappingType type, String key, boolean precreated, List<String> rawEntries, PoolConfiguration configuration) {
        this.id = id;
        this.type = type;
        this.genericKey = key;
        try {
            this.keyType = PoolKeyType.valueOf(PoolKeyType.class, key);
        }
        catch (IllegalArgumentException e) {
            this.keyType = PoolKeyType.generic;
        }
        this.precreated = precreated;
        this.rawEntries = rawEntries;
        this.configuration = configuration;
    }

    public String getId() {
        return this.id;
    }

    public MappingType getType() {
        return this.type;
    }

    public PoolKeyType getKeyType() {
        return this.keyType;
    }

    public String getKeyTypeCode() {
        if (this.getKeyType() == PoolKeyType.generic) {
            return "generic/" + this.getGenericKey();
        }
        return this.getKeyType().toString();
    }

    public boolean isPrecreated() {
        return this.precreated;
    }

    public PoolConfiguration getConfiguration() {
        return this.configuration;
    }

    public List<String> getRawEntries() {
        return this.rawEntries;
    }

    public String getGenericKey() {
        return this.genericKey;
    }

    public int getDbKey() {
        return this.dbKey;
    }

    public void setDbKey(int dbKey) {
        this.dbKey = dbKey;
    }

    public int getRealEntries() {
        return this.realEntries;
    }

    public void setRealEntries(int realEntries) {
        this.realEntries = realEntries;
    }
}

