/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server.dynamic;

import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.server.dynamic.EvaluationContext;
import de.fzj.unicore.xuudb.server.dynamic.Mapping;
import de.fzj.unicore.xuudb.server.dynamic.MappingType;
import eu.unicore.util.configuration.ConfigurationException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.log4j.Logger;

public class FixedMapping
extends Mapping {
    private static final Logger log = Log.getLogger((String)"unicore.xuudb.server", FixedMapping.class);
    public static final String ID = "fixed";
    private String[] values;

    public FixedMapping(String configuration, MappingType maps) {
        super(configuration, maps);
        String val = configuration.trim();
        if (val.length() == 0) {
            throw new ConfigurationException("Mapping of type fixed can not be configured with empty value");
        }
        this.values = this.getType().equals((Object)MappingType.supplementaryGids) ? configuration.trim().split("[ ]+") : new String[]{val};
    }

    @Override
    public void applyAttributes(EvaluationContext context, boolean overwrite, boolean dryRun) {
        switch (this.getType()) {
            case uid: {
                log.debug((Object)("Setting xlogin to: " + this.values[0]));
                context.setXlogin(this.values[0]);
                break;
            }
            case gid: {
                log.debug((Object)("Setting gid to: " + this.values[0]));
                context.setGid(this.values[0]);
                break;
            }
            case supplementaryGids: {
                if (overwrite) {
                    context.setSupplementaryGids(Arrays.asList(this.values));
                    log.debug((Object)("Setting supplementary groups to: " + context.getSupplementaryGids()));
                    break;
                }
                Collections.addAll(context.getSupplementaryGids(), this.values);
                log.debug((Object)("Adding the following supplementary groups: " + Arrays.toString(this.values)));
            }
        }
    }
}

