/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server.dynamic;

import de.fzJuelich.unicore.xuudb.SimplifiedAttributeType;
import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.server.dynamic.EvaluationContext;
import de.fzj.unicore.xuudb.server.dynamic.Mapping;
import de.fzj.unicore.xuudb.server.dynamic.MappingType;
import de.fzj.unicore.xuudb.server.dynamic.Rule;
import de.fzj.unicore.xuudb.server.dynamic.SpelContextBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class EvaluationEngine {
    private static final Logger log = Log.getLogger((String)"unicore.xuudb.server", EvaluationEngine.class);

    public void evaluate(List<Rule> rules, EvaluationContext ctx, boolean dryRun) {
        for (int i = 0; i < rules.size(); ++i) {
            Rule r = rules.get(i);
            StandardEvaluationContext spelCtx = this.createSpelContext(ctx);
            if (this.checkCondition(r.getCondition(), spelCtx, i)) {
                log.debug((Object)("Rule " + i + " condition hit."));
                List<Mapping> mappings = r.getActions();
                for (Mapping map : mappings) {
                    if (this.skip(map.getType(), ctx, r.isOverwrite())) continue;
                    map.applyAttributes(ctx, r.isOverwrite(), dryRun);
                }
                continue;
            }
            log.debug((Object)("Rule " + i + " condition was not hit."));
        }
    }

    protected boolean skip(MappingType type, EvaluationContext context, boolean overwrite) {
        if (overwrite) {
            return false;
        }
        if (type == MappingType.gid && context.isGidSet()) {
            log.debug((Object)"Skipping gid mapping as gid was already set");
            return true;
        }
        if (type == MappingType.uid && context.isXloginSet()) {
            log.debug((Object)"Skipping uid mapping as uid was already set");
            return true;
        }
        return false;
    }

    private StandardEvaluationContext createSpelContext(EvaluationContext ctx) {
        SimplifiedAttributeType[] attributesXml;
        SpelContextBean root = new SpelContextBean();
        HashMap<String, Set<String>> attributes = new HashMap<String, Set<String>>();
        for (SimplifiedAttributeType xmlA : attributesXml = ctx.getExtraAttributes()) {
            HashSet values = new HashSet();
            Collections.addAll(values, xmlA.getValueArray());
            attributes.put(xmlA.getName(), values);
        }
        root.setAttributes(attributes);
        root.setDn(ctx.getUserDN());
        root.setGid(ctx.getGid());
        HashSet<String> allGids = new HashSet<String>();
        allGids.add(ctx.getGid());
        allGids.addAll(ctx.getSupplementaryGids());
        root.setGids(allGids);
        root.setIssuer(ctx.getIssuerDN());
        root.setRole(ctx.getRole());
        root.setVo(ctx.getVo());
        root.setXlogin(ctx.getXlogin());
        return new StandardEvaluationContext((Object)root);
    }

    private boolean checkCondition(Expression condition, StandardEvaluationContext ctx, int i) {
        Object condResult;
        try {
            condResult = condition.getValue((org.springframework.expression.EvaluationContext)ctx);
        }
        catch (Exception e) {
            log.error((Object)("Skipping the rule number " + i + " as evaluation of its condition finished" + " with an error: " + e.toString()), (Throwable)e);
            return false;
        }
        if (!(condResult instanceof Boolean) || condResult == null) {
            log.error((Object)("Skipping the rule number " + i + " as evaluation of its condition finished with " + "a non boolean result. Result type is: " + condResult == null ? "null" : condResult.getClass().getName()));
            return false;
        }
        boolean result = (Boolean)condResult;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Rule number " + i + " condition returned " + result));
        }
        return result;
    }
}

