/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server.dynamic;

import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.server.FileWatcher;
import de.fzj.unicore.xuudb.server.db.IPoolStorage;
import de.fzj.unicore.xuudb.server.dynamic.FixedMapping;
import de.fzj.unicore.xuudb.server.dynamic.Mapping;
import de.fzj.unicore.xuudb.server.dynamic.MappingType;
import de.fzj.unicore.xuudb.server.dynamic.Pool;
import de.fzj.unicore.xuudb.server.dynamic.PoolConfiguration;
import de.fzj.unicore.xuudb.server.dynamic.PoolMapping;
import de.fzj.unicore.xuudb.server.dynamic.PoolsWatchdog;
import de.fzj.unicore.xuudb.server.dynamic.Rule;
import de.fzj.unicore.xuudb.server.dynamic.ScriptMapping;
import de.fzj.unicore.xuudb.server.dynamic.xbeans.Configuration;
import de.fzj.unicore.xuudb.server.dynamic.xbeans.DynamicAttributesDocument;
import de.fzj.unicore.xuudb.server.dynamic.xbeans.Pools;
import de.fzj.unicore.xuudb.server.dynamic.xbeans.Rules;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class DAPConfiguration {
    private static final int DEF_UPDATE_CHECK = 10000;
    private static final Logger log = Log.getLogger((String)"unicore.xuudb.server", DAPConfiguration.class);
    private File file;
    private ExpressionParser spelParser;
    private List<Rule> rules;
    private Map<String, Pool> pools;
    private ScheduledExecutorService poolsWatchdogExecutor;
    private IPoolStorage storage;
    private ScheduledExecutorService executor;

    public DAPConfiguration(File file, IPoolStorage storage, ScheduledExecutorService executor) throws IOException, ConfigurationException {
        this(file, storage, 10000, executor);
    }

    public DAPConfiguration(File file, IPoolStorage storage, int updateInterval, ScheduledExecutorService executor) throws IOException, ConfigurationException {
        this.file = file;
        this.executor = executor;
        this.poolsWatchdogExecutor = Executors.newSingleThreadScheduledExecutor();
        this.spelParser = new SpelExpressionParser();
        this.storage = storage;
        try {
            this.parse();
        }
        catch (XmlException e) {
            throw new ConfigurationException("Problem loading dynamic attributes configuration file: " + e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new ConfigurationException("Problem loading dynamic attributes configuration file: " + e.getMessage(), (Throwable)e);
        }
        if (updateInterval > 0) {
            this.startConfigWatcher(updateInterval);
        }
    }

    private void startConfigWatcher(long interval) {
        FileWatcher r;
        Runnable updater = new Runnable(){

            @Override
            public void run() {
                try {
                    log.debug((Object)"Configuration file change detected, reloading...");
                    DAPConfiguration.this.parse();
                    log.info((Object)"Successfully reloaded the configuration file");
                }
                catch (Exception e) {
                    Log.logException((String)"Updated configuration file is invalid, using the old configuration.", (Throwable)e, (Logger)log);
                }
            }
        };
        try {
            r = new FileWatcher(this.file, updater);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Can't start config file watcher as it was removed: " + e.toString()));
            return;
        }
        log.info((Object)("Config file monitoring enabled with interval: " + interval + "ms"));
        this.executor.scheduleWithFixedDelay(r, interval, interval, TimeUnit.MILLISECONDS);
    }

    private void parse() throws IOException, XmlException, ParseException {
        ArrayList validationErrors;
        DynamicAttributesDocument mainDoc = DynamicAttributesDocument.Factory.parse(new BufferedInputStream(new FileInputStream(this.file)));
        boolean valid = mainDoc.validate(new XmlOptions().setErrorListener(validationErrors = new ArrayList()));
        if (!valid) {
            throw new ParseException(((Object)validationErrors).toString(), -1);
        }
        DynamicAttributesDocument.DynamicAttributes main = mainDoc.getDynamicAttributes();
        Configuration generalConfiguration = main.getDefaultConfiguration();
        int timeout = 20000;
        if (generalConfiguration == null) {
            generalConfiguration = Configuration.Factory.newInstance();
        }
        if (generalConfiguration.isSetHandlerInvocationTimeLimit()) {
            timeout = generalConfiguration.getHandlerInvocationTimeLimit();
        }
        Pools pools = main.getPools();
        Map<String, Pool> newPools = this.parsePools(pools, generalConfiguration);
        Rules rules = main.getRules();
        List<Rule> newRules = this.parseRules(rules, newPools, timeout);
        int updateDelay = main.isSetPoolMonitoringDelay() ? main.getPoolMonitoringDelay() : 86400;
        this.update(newRules, newPools, updateDelay);
    }

    private synchronized void update(List<Rule> newRules, Map<String, Pool> pools, long period) {
        this.storage.initializePools(pools.values());
        this.poolsWatchdogExecutor.shutdownNow();
        if (period > 0L) {
            this.poolsWatchdogExecutor = Executors.newSingleThreadScheduledExecutor();
            this.poolsWatchdogExecutor.scheduleAtFixedRate(new PoolsWatchdog(this.storage, pools.values()), period, period, TimeUnit.SECONDS);
            log.info((Object)("Started a pools monitoring task with the interval " + period + "s"));
        } else {
            log.info((Object)"Pools monitoring task is disabled");
        }
        this.rules = newRules;
        this.pools = pools;
    }

    public synchronized List<Rule> getRules() {
        return this.rules;
    }

    public synchronized Map<String, Pool> getPools() {
        return this.pools;
    }

    private Map<String, Pool> parsePools(Pools xmlPools, Configuration generalConfiguration) throws ParseException, IOException {
        HashMap<String, Pool> ret = new HashMap<String, Pool>();
        if (xmlPools == null) {
            return ret;
        }
        de.fzj.unicore.xuudb.server.dynamic.xbeans.Pool[] xmlPoolA = xmlPools.getPoolArray();
        if (xmlPoolA == null || xmlPoolA.length == 0) {
            return ret;
        }
        for (de.fzj.unicore.xuudb.server.dynamic.xbeans.Pool xmlPool : xmlPoolA) {
            Configuration poolCfg;
            String[] files;
            MappingType type = this.getMappingType(xmlPool.getType());
            boolean isPrecreated = xmlPool.getPrecreated();
            ArrayList<String> entries = new ArrayList<String>();
            String[] ids = xmlPool.getIdArray();
            if (ids != null) {
                for (int i = 0; i < ids.length; ++i) {
                    entries.add(ids[i]);
                }
            }
            if ((files = xmlPool.getFileArray()) != null) {
                for (int i = 0; i < files.length; ++i) {
                    this.loadFileIds(entries, files[i]);
                }
            }
            if ((poolCfg = xmlPool.getConfiguration()) == null) {
                poolCfg = Configuration.Factory.newInstance();
            }
            Pool p = new Pool(xmlPool.getId2(), type, xmlPool.getKey(), isPrecreated, entries, new PoolConfiguration(poolCfg, generalConfiguration));
            ret.put(p.getId(), p);
        }
        return ret;
    }

    private List<Rule> parseRules(Rules rules, Map<String, Pool> newPools, int timeout) throws ParseException {
        ArrayList<Rule> ret = new ArrayList<Rule>();
        if (rules == null) {
            return ret;
        }
        de.fzj.unicore.xuudb.server.dynamic.xbeans.Rule[] rulesA = rules.getRuleArray();
        if (rulesA == null || rulesA.length == 0) {
            return ret;
        }
        for (de.fzj.unicore.xuudb.server.dynamic.xbeans.Rule xmlRule : rulesA) {
            String rawCond = xmlRule.getCondition();
            if (rawCond == null) {
                throw new ParseException("Rule without a condition found", -1);
            }
            Expression e = this.parseSpEL(rawCond);
            boolean overwriteExisting = xmlRule.isSetOverwriteExisting() ? xmlRule.getOverwriteExisting() : false;
            de.fzj.unicore.xuudb.server.dynamic.xbeans.Mapping[] xmlMappings = xmlRule.getMappingArray();
            if (xmlMappings == null || xmlMappings.length == 0) {
                throw new ParseException("Rule without mapping found", -1);
            }
            ArrayList<Mapping> mappings = new ArrayList<Mapping>();
            for (de.fzj.unicore.xuudb.server.dynamic.xbeans.Mapping xmlMapping : xmlMappings) {
                mappings.add(this.parseMapping(xmlMapping, newPools, timeout));
            }
            ret.add(new Rule(e, overwriteExisting, mappings));
        }
        return ret;
    }

    private Mapping parseMapping(de.fzj.unicore.xuudb.server.dynamic.xbeans.Mapping xmlMapping, Map<String, Pool> newPools, int timeout) throws ParseException {
        String contents = xmlMapping.getStringValue();
        String type = xmlMapping.getType();
        String maps = xmlMapping.getMaps();
        if ("fixed".equalsIgnoreCase(type)) {
            if (maps == null) {
                throw new ParseException("The 'maps' parameter is required for " + type + " mapping", -1);
            }
            return new FixedMapping(contents, this.getMappingType(maps));
        }
        if ("script".equalsIgnoreCase(type)) {
            if (maps == null) {
                throw new ParseException("The 'maps' parameter is required for " + type + " mapping", -1);
            }
            return new ScriptMapping(contents, this.getMappingType(maps), timeout);
        }
        if ("pool".equalsIgnoreCase(type)) {
            Pool pool = newPools.get(contents.trim());
            if (pool == null) {
                throw new ParseException("Unknown pool used in mapping: " + contents.trim(), -1);
            }
            PoolMapping ret = new PoolMapping(pool, this.storage);
            if (maps != null && ret.getType() != this.getMappingType(maps)) {
                throw new ParseException("Inconsistent pool type (" + (Object)((Object)ret.getType()) + ") and mapping 'maps' attribute (" + maps + ")." + " Those values must be the same, or the 'maps' attribute " + "can be removed for pool mapping.", -1);
            }
            return ret;
        }
        throw new ParseException("Unknown mapping type found: " + type, -1);
    }

    private void loadFileIds(List<String> where, String file) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(file));
        while ((line = br.readLine()) != null) {
            where.add(line.trim());
        }
        br.close();
    }

    private MappingType getMappingType(String s) throws ParseException {
        try {
            return MappingType.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Got wrong value of what is generated by a mapping (or pool): " + s + ", must be one of " + Arrays.toString((Object[])MappingType.values()), -1);
        }
    }

    private Expression parseSpEL(String expr) throws ParseException {
        try {
            return this.spelParser.parseExpression(expr);
        }
        catch (org.springframework.expression.ParseException e) {
            throw new ParseException("Problem parsing SpEL '" + expr + "': " + e.getMessage(), e.getPosition());
        }
        catch (Exception ee) {
            throw new ParseException("Other problem parsing SpEL expression '" + expr + "': " + ee.toString(), -1);
        }
    }
}

