/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server.db;

import de.fzj.unicore.xuudb.Log;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.log4j.Logger;

public class MyBatisSessionFactory {
    private static final Logger log = Log.getLogger((String)"unicore.xuudb.server.db", MyBatisSessionFactory.class);
    private SqlSessionFactory sqlMapFactory;
    private Map<SqlSession, Thread> openSessions = new HashMap<SqlSession, Thread>();
    private boolean shutdown = false;

    public MyBatisSessionFactory(InputStream configuration, Properties properties) {
        SqlSessionFactoryBuilder builder = new SqlSessionFactoryBuilder();
        this.sqlMapFactory = builder.build(configuration, properties);
    }

    public synchronized SqlSession openSession(boolean transactional) {
        if (this.shutdown) {
            throw new IllegalStateException("Server is being shut down. No new operations can be served.");
        }
        SqlSession ret = this.sqlMapFactory.openSession(!transactional);
        this.openSessions.put(ret, Thread.currentThread());
        return ret;
    }

    public synchronized SqlSession openBatchSession(boolean transactional) {
        if (this.shutdown) {
            throw new IllegalStateException("Server is being shut down. No new operations can be served.");
        }
        SqlSession ret = this.sqlMapFactory.openSession(ExecutorType.BATCH, !transactional);
        this.openSessions.put(ret, Thread.currentThread());
        return ret;
    }

    public synchronized void closeSession(SqlSession session) {
        if (this.openSessions.remove(session) == null) {
            throw new IllegalStateException("Can not close session which was not retrieved from this factory.");
        }
        session.close();
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        int c = 0;
        int maxIter = 50;
        int wait = 100;
        while (this.openSessions.size() > 0) {
            try {
                this.wait(wait);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (++c <= maxIter) continue;
            log.fatal((Object)("Waited " + maxIter * wait + "ms and there are still open " + "(stalled?) DB connections. The faulty threads dump is following. " + "Closing the server forcefully, DB might be corrupted."));
            for (Thread t : this.openSessions.values()) {
                log.fatal((Object)("Stalled thread: " + t.getName() + "\n" + Arrays.toString(t.getStackTrace())));
            }
        }
        ((PooledDataSource)this.sqlMapFactory.getConfiguration().getEnvironment().getDataSource()).forceCloseAll();
    }
}

