/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server.db;

import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.server.IShutdownable;
import de.fzj.unicore.xuudb.server.ShutdownHook;
import de.fzj.unicore.xuudb.server.db.DatabaseProperties;
import de.fzj.unicore.xuudb.server.db.IClassicStorage;
import de.fzj.unicore.xuudb.server.db.IPoolStorage;
import de.fzj.unicore.xuudb.server.db.IStorage;
import de.fzj.unicore.xuudb.server.db.MyBatisClassicDB;
import de.fzj.unicore.xuudb.server.db.MyBatisPoolDB;
import de.fzj.unicore.xuudb.server.db.MyBatisSessionFactory;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ibatis.io.Resources;
import org.apache.log4j.Logger;

public class MyBatisDatabase
implements IShutdownable,
IStorage {
    public static final Logger log = Log.getLogger((String)"unicore.xuudb.server.db", MyBatisDatabase.class);
    public static final String DEF_CONFIG_LOCATION = "mybatis/sqlconfig.xml";
    private MyBatisClassicDB classicDB;
    private MyBatisPoolDB poolDB;
    private MyBatisSessionFactory factory;

    public MyBatisDatabase(boolean dnMode, DatabaseProperties properties, ShutdownHook shutdown) throws IOException {
        this(Resources.getResourceAsStream((String)DEF_CONFIG_LOCATION), properties, dnMode, shutdown);
    }

    public MyBatisDatabase(InputStream configuration, DatabaseProperties properties, boolean dnMode, ShutdownHook shutdown) {
        this.factory = new MyBatisSessionFactory(configuration, properties.getProperties());
        this.classicDB = new MyBatisClassicDB(this.factory, dnMode);
        this.poolDB = new MyBatisPoolDB(this.factory);
    }

    @Override
    public IClassicStorage getClassicStorage() {
        return this.classicDB;
    }

    @Override
    public IPoolStorage getPoolStorage() {
        return this.poolDB;
    }

    @Override
    public void shutdown() {
        this.factory.shutdown();
    }

    @Override
    public String getNameOfService() {
        return "XUUDB MyBatis Database";
    }
}

