/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server.db;

import de.fzJuelich.unicore.xuudb.DatabaseType;
import de.fzJuelich.unicore.xuudb.ImportDatabaseDocument;
import de.fzJuelich.unicore.xuudb.LoginDataType;
import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.server.SecurityToken;
import de.fzj.unicore.xuudb.server.Xlogin;
import de.fzj.unicore.xuudb.server.db.IClassicStorage;
import de.fzj.unicore.xuudb.server.db.LoginBean;
import de.fzj.unicore.xuudb.server.db.MyBatisSessionFactory;
import de.fzj.unicore.xuudb.server.db.UudbClassicMapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.SqlSession;
import org.apache.log4j.Logger;

public class MyBatisClassicDB
implements IClassicStorage {
    public static final Logger log = Log.getLogger((String)"unicore.xuudb.server.db", MyBatisClassicDB.class);
    private MyBatisSessionFactory factory;
    private boolean dnMode;
    private static final String ST_CREATE_TABLE = "create-records-table";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MyBatisClassicDB(MyBatisSessionFactory factory, boolean dnMode) {
        this.factory = factory;
        this.dnMode = dnMode;
        SqlSession session = factory.openSession(false);
        try {
            session.update(ST_CREATE_TABLE);
        }
        finally {
            factory.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String add(LoginDataType addRequest) throws IllegalArgumentException, PersistenceException {
        log.debug((Object)"Adding into UUDB");
        LoginBean bean = new LoginBean(addRequest, this.dnMode);
        SqlSession session = this.factory.openSession(true);
        if (bean.getGcid() == null || bean.getToken() == null) {
            throw new IllegalArgumentException("Token and GCID must be set when adding an entry");
        }
        if (bean.getGcid() == "*") {
            throw new IllegalArgumentException("Token and GCID must not be '*'");
        }
        try {
            UudbClassicMapper mapper = (UudbClassicMapper)session.getMapper(UudbClassicMapper.class);
            LoginBean existing = mapper.getRecord(bean.getGcid(), bean.getToken());
            if (existing != null) {
                log.debug((Object)"Found existing entry, will update it instead of adding a duplicate");
                Xlogin xlogin = new Xlogin(existing.getXlogin());
                boolean added = xlogin.addLogin(bean.getXlogin());
                String ret = "OK";
                if (added) {
                    log.debug((Object)("Adding new xlogin <" + bean.getXlogin() + "> to existing entry."));
                    bean.setXlogin(xlogin.getEncoded());
                    int updated = mapper.updateRecord(bean.getGcid(), bean.getToken(), bean);
                    ret = "Updated " + updated + " rows";
                } else {
                    log.debug((Object)("Xlogin <" + bean.getXlogin() + "> already exists in entry, skipping update."));
                }
                session.commit();
                String string = ret;
                return string;
            }
            mapper.insertRecord(bean);
            session.commit();
        }
        finally {
            this.factory.closeSession(session);
        }
        return "OK.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String import_csv(ImportDatabaseDocument idd) throws IllegalArgumentException, PersistenceException {
        DatabaseType db = idd.getImportDatabase();
        LoginDataType[] logins = db.getDatabaseArray();
        int occuredErrors = 0;
        boolean clear = false;
        if (idd.getImportDatabase().isSetClean()) {
            clear = idd.getImportDatabase().getClean();
        }
        SqlSession session = this.factory.openSession(true);
        try {
            UudbClassicMapper mapper = (UudbClassicMapper)session.getMapper(UudbClassicMapper.class);
            if (clear) {
                log.info((Object)"Clearing database before import.");
                mapper.removeRecords(new LoginBean());
            }
            for (int i = 0; i < logins.length; ++i) {
                try {
                    LoginBean bean = new LoginBean(logins[i], this.dnMode);
                    mapper.insertRecord(bean);
                    continue;
                }
                catch (Exception e) {
                    log.warn((Object)("Error importing entry: " + e));
                    ++occuredErrors;
                }
            }
            session.commit();
            String string = logins.length - occuredErrors + "   certificates from   " + logins.length + "   were imported into the XUUDB.";
            return string;
        }
        finally {
            this.factory.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginDataType[] listDB(LoginDataType query) throws IllegalArgumentException, PersistenceException {
        log.debug((Object)"Listing UUDB contents");
        LoginBean bean = new LoginBean(query, this.dnMode);
        SqlSession session = this.factory.openSession(false);
        try {
            UudbClassicMapper mapper = (UudbClassicMapper)session.getMapper(UudbClassicMapper.class);
            List<LoginBean> result = mapper.queryRecords(bean);
            LoginDataType[] ret = new LoginDataType[result.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = result.get(i).getAsLoginDataType();
            }
            LoginDataType[] loginDataTypeArray = ret;
            return loginDataTypeArray;
        }
        finally {
            this.factory.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String remove(LoginDataType removeArg) throws IllegalArgumentException, PersistenceException {
        log.debug((Object)"Removing records or xlogins from UUDB");
        LoginBean bean = new LoginBean(removeArg, this.dnMode);
        SqlSession session = this.factory.openSession(true);
        try {
            UudbClassicMapper mapper = (UudbClassicMapper)session.getMapper(UudbClassicMapper.class);
            List<LoginBean> existing = new ArrayList<LoginBean>();
            if (bean.getToken() != null && bean.getXlogin() != null) {
                if (bean.getGcid() == null || bean.getGcid().equals("*")) {
                    LoginBean query = new LoginBean();
                    query.setToken(bean.getToken());
                    existing = mapper.queryRecords(query);
                } else {
                    existing.add(mapper.getRecord(bean.getGcid(), bean.getToken()));
                }
            }
            int removed = 0;
            int updated = 0;
            if (existing.size() > 0) {
                for (LoginBean lb : existing) {
                    Xlogin xlogin = new Xlogin(lb.getXlogin());
                    Xlogin toRemove = new Xlogin(bean.getXlogin());
                    for (String login : toRemove) {
                        boolean removedL = xlogin.removeLogin(login);
                        if (removedL) continue;
                        log.debug((Object)("Xlogin " + login + " not found in entry " + xlogin + ", ignoring."));
                    }
                    if (xlogin.getNumberOfLogins() == 0) {
                        log.debug((Object)"Removing entry");
                        removed += mapper.removeRecords(lb);
                        continue;
                    }
                    log.debug((Object)("Updating xlogin to <" + xlogin + ">."));
                    lb.setXlogin(xlogin.getEncoded());
                    updated += mapper.updateRecord(lb.getGcid(), lb.getToken(), lb);
                }
            } else {
                removed = mapper.removeRecords(bean);
            }
            session.commit();
            String string = "Removed records: " + removed + "; updated records: " + updated;
            return string;
        }
        finally {
            this.factory.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginDataType checkToken(String gcid, String token) throws IllegalArgumentException, PersistenceException {
        log.debug((Object)"Checking if token is present in UUDB");
        SecurityToken stok = new SecurityToken(token, this.dnMode);
        SqlSession session = this.factory.openSession(false);
        try {
            UudbClassicMapper mapper = (UudbClassicMapper)session.getMapper(UudbClassicMapper.class);
            LoginBean existing = mapper.getRecord(gcid, stok.getToken());
            if (existing == null) {
                LoginDataType loginDataType = LoginDataType.Factory.newInstance();
                return loginDataType;
            }
            LoginDataType loginDataType = existing.getAsLoginDataType();
            return loginDataType;
        }
        finally {
            this.factory.closeSession(session);
        }
    }

    @Override
    public LoginDataType checkDN(String gcid, String dn) throws IllegalArgumentException, PersistenceException {
        if (this.dnMode) {
            return this.checkToken(gcid, dn);
        }
        throw new IllegalArgumentException("Server is configured to only accept full certificates in queries");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String update(String gcid, String token, LoginDataType login) throws IllegalArgumentException, PersistenceException {
        log.debug((Object)"Updateing UUDB");
        SecurityToken stok = new SecurityToken(token, this.dnMode);
        SqlSession session = this.factory.openSession(true);
        try {
            LoginBean bean = new LoginBean(login, this.dnMode);
            UudbClassicMapper mapper = (UudbClassicMapper)session.getMapper(UudbClassicMapper.class);
            int updated = mapper.updateRecord(gcid, stok.getToken(), bean);
            session.commit();
            String string = "Updated   " + updated + "   rows.";
            return string;
        }
        finally {
            this.factory.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listGCIDs() throws IllegalArgumentException, PersistenceException {
        log.debug((Object)"Listing GCIDs");
        SqlSession session = this.factory.openSession(true);
        try {
            UudbClassicMapper mapper = (UudbClassicMapper)session.getMapper(UudbClassicMapper.class);
            List<String> list = mapper.listGcids();
            return list;
        }
        finally {
            this.factory.closeSession(session);
        }
    }
}

