/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server;

import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.server.FileWatcher;
import de.fzj.unicore.xuudb.server.HttpsServer;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class XUUDBServer {
    private static final Logger logger = Log.getLogger((String)"unicore.xuudb.server", XUUDBServer.class);
    private ScheduledExecutorService executorService;

    public static void main(String[] args) {
        if (args.length == 0) {
            XUUDBServer.printUsage();
        } else {
            new XUUDBServer().run(args);
        }
    }

    private void run(String[] args) {
        if (args.length == 0) {
            XUUDBServer.printUsage();
        }
        this.executorService = Executors.newScheduledThreadPool(5);
        String configFile = new File("conf", "xuudb_server.conf").getPath();
        this.startLogConfigWatcher();
        if (args[0].equalsIgnoreCase("--start")) {
            if (args.length > 1) {
                configFile = args[1];
            }
            try {
                logger.info((Object)("Starting XUUDB server with configuration from <" + configFile + ">"));
                System.out.println("Starting XUUDB server with configuration from <" + configFile + ">");
                new HttpsServer(configFile, this.executorService).start();
                logger.info((Object)"XUUDB server startup completed");
                System.out.println("XUUDB server startup completed");
            }
            catch (Exception e) {
                logger.error((Object)"Problem starting the server", (Throwable)e);
                e.printStackTrace();
                System.out.println("Cannot start XUUDB.");
                System.exit(1);
            }
        }
    }

    private void startLogConfigWatcher() {
        final String logConfig = System.getProperty("log4j.configuration");
        if (logConfig == null) {
            logger.debug((Object)"No log4j config defined.");
            return;
        }
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    logger.info((Object)"LOG CONFIG MODIFIED, re-configuring.");
                    PropertyConfigurator.configure((String)logConfig);
                }
            };
            File logProperties = logConfig.startsWith("file:") ? new File(new URI(logConfig)) : new File(logConfig);
            FileWatcher fw = new FileWatcher(logProperties, r);
            this.executorService.scheduleWithFixedDelay(fw, 5L, 5L, TimeUnit.SECONDS);
            logger.info((Object)("Monitoring log configuration at <" + logProperties.getAbsolutePath() + ">"));
        }
        catch (FileNotFoundException fex) {
            System.err.println("Log configuration file <" + logConfig + "> not found.");
        }
        catch (URISyntaxException use) {
            System.err.println("Not a valid URI: <" + logConfig + ">.");
        }
    }

    public static void printUsage() {
        System.out.println("\nUsage: start_cmd  <command>  [parameters]\n\t--start  <configfile>   starts XUUDB server");
    }
}

