/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server;

import de.fzj.unicore.xuudb.AbstractConfiguration;
import de.fzj.unicore.xuudb.Log;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ServerConfiguration
extends AbstractConfiguration {
    private static final Logger logger = Log.getLogger((String)"unicore.configuration", ServerConfiguration.class);
    public static final String PROP_XUUDBTYPE = "type";
    public static final String PROP_ACL_FILE = "aclFile";
    public static final String PROP_PROTECT_ALL = "protectAll";
    public static final String PROP_DAP_FILE = "dynamicAttributesConfig";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> DEFAULTS = new HashMap<String, PropertyMD>();

    public ServerConfiguration(File config) throws IOException {
        super("xuudb.", FilePropertiesHelper.load((File)config), DEFAULTS, logger);
        this.checkConfigFile(config);
    }

    public ServerConfiguration(Properties p) {
        super("xuudb.", p, DEFAULTS, logger);
    }

    private void checkConfigFile(File config) throws IOException {
        String updateInfo = this.createConfigUpdateHint();
        if (updateInfo.length() > 0) {
            logger.error((Object)("The configuration in the " + config + " file uses the obsolete syntax." + " Please consult the documentation and perform the suggested updates:\n" + updateInfo));
            throw new IOException("Obsolete syntax in the configuration file was detected");
        }
        logger.info((Object)("Loaded Configuration from file: " + config.getPath()));
    }

    protected String createConfigUpdateHint() {
        StringBuilder newOnes = new StringBuilder();
        StringBuilder oldOnes = new StringBuilder();
        this.createCommonConfigUpdateHint(newOnes, oldOnes);
        String XUUDBTYPE = "xuudb_type";
        if (this.properties.contains("xuudb_type")) {
            oldOnes.append("xuudb_type").append("\n");
            newOnes.append("truststore.type=" + this.properties.getProperty("xuudb_type"));
        }
        if (oldOnes.length() > 0) {
            return "Entries to be removed from the config file:\n" + oldOnes + "\nEntries to be added:\n" + newOnes;
        }
        return "";
    }

    static {
        DEFAULTS.put("address", new PropertyMD("http://localhost:34463").setDescription("HTTPS or HTTP URL where the server should listen."));
        DEFAULTS.put(PROP_XUUDBTYPE, new PropertyMD((Enum)XuudbModes.normal).setDescription("Controls whether full certificates or DNs only are stored in the static XUUDB."));
        DEFAULTS.put(PROP_DAP_FILE, new PropertyMD("conf/dynamicAttributesCfg.xml").setPath().setDescription("File with configuration of the dynamic part of the XUUDB."));
        DEFAULTS.put(PROP_ACL_FILE, new PropertyMD().setPath().setDescription("File with DNs of clients authorised to access protected XUUDB services."));
        DEFAULTS.put(PROP_PROTECT_ALL, new PropertyMD("false").setDescription("If true then access to both query and modify operations are protected by ACL. If false then only modification operations are protected."));
        DEFAULTS.put("db.", new PropertyMD().setCanHaveSubkeys().setDescription("Properties with this prefix are used to configure database backend, used by XUUDB. See separate documentation for details."));
        DEFAULTS.put("httpServer.", new PropertyMD().setCanHaveSubkeys().setHidden().setDescription("Properties with this prefix are used to configure advanced Jetty HTTP server settings. See separate documentation for details."));
        DEFAULTS.put("truststore.", new PropertyMD().setCanHaveSubkeys().setHidden().setDescription("Properties with this prefix are used to configure the server's credential. See separate documentation for details."));
        DEFAULTS.put("credential.", new PropertyMD().setCanHaveSubkeys().setHidden().setDescription("Properties with this prefix are used to configure trust and certificate validation settings. See separate documentation for details."));
    }

    public static enum XuudbModes {
        normal,
        dn;

    }
}

