/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server;

import de.fzj.unicore.xuudb.X509Utils;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.IOException;
import java.security.cert.X509Certificate;

public class SecurityToken {
    private String token;
    private String source;
    private boolean certificateToken;
    private X509Certificate certificate = null;

    public SecurityToken(String rawToken, boolean dnMode) throws IllegalArgumentException {
        this.source = rawToken;
        this.resolveType(rawToken);
        if (!dnMode && !this.certificateToken) {
            throw new IllegalArgumentException("Sorry, but that's not a pem encoded X509Certificate: " + rawToken + "\nDatabase mode is set to 'normal'. " + "Only full certificates can be used.");
        }
        this.token = dnMode ? this.buildDNToken(rawToken) : this.buildCertificateToken(rawToken);
    }

    protected void resolveType(String source) {
        if (source.length() > 200) {
            if (!this.tryCertificate(source, false)) {
                this.tryDN(source, true);
            }
        } else if (!this.tryDN(source, false)) {
            this.tryCertificate(source, true);
        }
    }

    protected boolean tryCertificate(String source, boolean fail) {
        try {
            this.certificate = X509Utils.getX509FromPEMString((String)source);
            this.certificateToken = true;
            return true;
        }
        catch (Exception ce) {
            if (fail) {
                throw new IllegalArgumentException("Token is not a DN or x509 cert.");
            }
            return false;
        }
    }

    protected boolean tryDN(String source, boolean fail) {
        try {
            X500NameUtils.getX500Principal((String)source);
            this.certificateToken = false;
            return true;
        }
        catch (Exception ce) {
            if (fail) {
                throw new IllegalArgumentException("Token is not a DN or x509 cert.");
            }
            return false;
        }
    }

    protected String buildDNToken(String token) throws IllegalArgumentException {
        if (!this.certificateToken) {
            return X500NameUtils.getComparableForm((String)token);
        }
        return X500NameUtils.getComparableForm((String)this.certificate.getSubjectX500Principal().getName());
    }

    protected String buildCertificateToken(String token) throws IllegalArgumentException {
        try {
            X509Utils.getX509FromPEMString((String)token);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't parse the provided token as a PEM certificate", e);
        }
        return token.replace("\n", "");
    }

    public String toString() {
        return this.token;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SecurityToken)) {
            return false;
        }
        return this.token.equalsIgnoreCase(obj.toString());
    }

    public int hashCode() {
        return this.token.toLowerCase().hashCode() ^ 0x36593265;
    }

    public String getToken() {
        return this.token;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isCertificateToken() {
        return this.certificateToken;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }
}

