/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server;

import de.fzJuelich.unicore.xuudb.CheckCertChainResponseDocument;
import de.fzJuelich.unicore.xuudb.CheckCertificateChainDocument;
import de.fzJuelich.unicore.xuudb.CheckCertificateDocument;
import de.fzJuelich.unicore.xuudb.CheckCertificateResponseDocument;
import de.fzJuelich.unicore.xuudb.CheckDNDocument;
import de.fzJuelich.unicore.xuudb.CheckDNResponseDocument;
import de.fzJuelich.unicore.xuudb.LoginDataType;
import de.fzj.unicore.xuudb.AbstractConfiguration;
import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.X509Utils;
import de.fzj.unicore.xuudb.interfaces.IPublic;
import de.fzj.unicore.xuudb.server.db.IClassicStorage;
import java.io.ByteArrayInputStream;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.log4j.Logger;
import org.codehaus.xfire.util.Base64;

public class PublicImpl
implements IPublic {
    private static final Logger logger = Log.getLogger((String)"unicore.xuudb.server", PublicImpl.class);
    private IClassicStorage db;

    public PublicImpl(AbstractConfiguration co, IClassicStorage backend) throws Exception {
        this.db = backend;
    }

    public CheckCertificateResponseDocument checkCertificate(CheckCertificateDocument xml) {
        try {
            CheckCertificateResponseDocument ret = CheckCertificateResponseDocument.Factory.newInstance();
            String certinpem = xml.getCheckCertificate().getCertInPEM();
            String gcid = xml.getCheckCertificate().getGcID();
            LoginDataType data = this.db.checkToken(gcid, certinpem);
            if (data == null) {
                data = LoginDataType.Factory.newInstance();
            }
            ret.setCheckCertificateResponse(data);
            return ret;
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("Got wrong/unparsable argument: " + xml.xmlText() + "\nError is: " + e.toString()));
            throw e;
        }
        catch (PersistenceException e) {
            Log.logException((String)"Error in database code", (Throwable)e, (Logger)logger);
            String msg = Log.createFaultMessage((String)"Internal server error, database related", (Throwable)e);
            throw new RuntimeException(msg);
        }
    }

    public CheckCertChainResponseDocument checkCertificateChain(CheckCertificateChainDocument xml) {
        try {
            CheckCertChainResponseDocument ret = CheckCertChainResponseDocument.Factory.newInstance();
            String gcid = xml.getCheckCertificateChain().getGcID();
            String base64 = xml.getCheckCertificateChain().getEncodedChain();
            byte[] cpb = Base64.decode((String)base64);
            ByteArrayInputStream is = new ByteArrayInputStream(cpb);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            CertPath cp = cf.generateCertPath(is);
            LoginDataType data = null;
            Certificate o = cp.getCertificates().get(0);
            data = this.db.checkToken(gcid, X509Utils.getPEMStringFromX509((Certificate)((X509Certificate)o)));
            ret.setCheckCertChainResponse(data);
            return ret;
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("Got wrong/unparsable argument: " + xml.xmlText() + "\nError is: " + e.toString()));
            throw e;
        }
        catch (PersistenceException e) {
            Log.logException((String)"Error in database code", (Throwable)e, (Logger)logger);
            String msg = Log.createFaultMessage((String)"Internal server error, database related", (Throwable)e);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            String msg = "Got wrong/unparsable argument: " + xml.xmlText() + "\nError is: " + e.toString();
            logger.warn((Object)msg);
            throw new IllegalArgumentException(msg);
        }
    }

    public CheckDNResponseDocument checkDN(CheckDNDocument xml) {
        try {
            CheckDNResponseDocument ret = CheckDNResponseDocument.Factory.newInstance();
            String gcid = xml.getCheckDN().getGcID();
            String dn = xml.getCheckDN().getDistinguishedName();
            LoginDataType data = this.db.checkDN(gcid, dn);
            ret.setCheckDNResponse(data);
            return ret;
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("Got wrong/unparsable argument: " + xml.xmlText() + "\nError is: " + e.toString()));
            throw e;
        }
        catch (PersistenceException e) {
            Log.logException((String)"Error in database code", (Throwable)e, (Logger)logger);
            String msg = Log.createFaultMessage((String)"Internal server error, database related", (Throwable)e);
            throw new RuntimeException(msg);
        }
    }
}

