/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server;

import de.fzj.unicore.xuudb.AbstractConfiguration;
import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.interfaces.IAdmin;
import de.fzj.unicore.xuudb.interfaces.IDAPAdmin;
import de.fzj.unicore.xuudb.interfaces.IDynamicAttributesPublic;
import de.fzj.unicore.xuudb.interfaces.IPublic;
import de.fzj.unicore.xuudb.server.ACLHandler;
import de.fzj.unicore.xuudb.server.AdminImpl;
import de.fzj.unicore.xuudb.server.DAPAdminImpl;
import de.fzj.unicore.xuudb.server.DAPPublicImpl;
import de.fzj.unicore.xuudb.server.IShutdownable;
import de.fzj.unicore.xuudb.server.JettyServer;
import de.fzj.unicore.xuudb.server.PublicImpl;
import de.fzj.unicore.xuudb.server.ServerConfiguration;
import de.fzj.unicore.xuudb.server.ShutdownHook;
import de.fzj.unicore.xuudb.server.db.IStorage;
import de.fzj.unicore.xuudb.server.db.StorageFactory;
import de.fzj.unicore.xuudb.server.dynamic.DAPConfiguration;
import eu.unicore.security.canl.AuthnAndTrustProperties;
import eu.unicore.util.jetty.HttpServerProperties;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.invoker.BeanInvoker;
import org.codehaus.xfire.service.invoker.Invoker;
import org.codehaus.xfire.xmlbeans.XmlBeansServiceFactory;

public class HttpsServer
implements IShutdownable {
    private static final Logger logger = Log.getLogger((String)"unicore.xuudb.server", HttpsServer.class);
    private JettyServer server;
    private XFire xfire;
    private ServerConfiguration config;
    private ScheduledExecutorService executor;
    private IAdmin adminImpl;
    private IDAPAdmin dapAdminImpl;
    private IPublic publicImpl;
    private IDynamicAttributesPublic dapPublicImpl;

    public HttpsServer(Properties p, ScheduledExecutorService executor) throws Exception {
        this.config = new ServerConfiguration(p);
        this.executor = executor;
    }

    public HttpsServer(String cf, ScheduledExecutorService executor) throws Exception {
        this.executor = executor;
        try {
            this.config = new ServerConfiguration(new File(cf));
        }
        catch (IOException e) {
            throw new Exception("Cannot get configuration from " + cf + "\n*** Create a default configuration with tha 'init' admin command", e);
        }
        String v = AbstractConfiguration.class.getPackage().getImplementationVersion();
        logger.info((Object)"");
        logger.info((Object)"******************************************");
        logger.info((Object)"*    UNICORE AUTHORISATION SERVICE");
        if (v != null) {
            logger.info((Object)("*    Version " + v));
        }
        logger.info((Object)"*    http://www.unicore.eu");
        logger.info((Object)"******************************************");
    }

    public void start() throws Exception {
        this.xfire = XFireFactory.newInstance().getXFire();
        XmlBeansServiceFactory serviceFactory = new XmlBeansServiceFactory();
        ShutdownHook hook = new ShutdownHook();
        IStorage storage = StorageFactory.getDatabase(this.config, hook);
        Service adminService = serviceFactory.create(IAdmin.class, "XUUDBAdmin", null, null);
        this.adminImpl = new AdminImpl(this.config, storage.getClassicStorage());
        adminService.setInvoker((Invoker)new BeanInvoker((Object)this.adminImpl));
        String acl = this.config.getValue("aclFile");
        ACLHandler aclHandler = acl != null ? new ACLHandler(new File(acl), this.executor) : new ACLHandler(this.executor);
        adminService.addInHandler((Handler)aclHandler);
        this.xfire.getServiceRegistry().register(adminService);
        Service publicService = serviceFactory.create(IPublic.class, "XUUDBQuery", null, null);
        this.publicImpl = new PublicImpl(this.config, storage.getClassicStorage());
        publicService.setInvoker((Invoker)new BeanInvoker((Object)this.publicImpl));
        if (this.config.getBooleanValue("protectAll").booleanValue()) {
            publicService.addInHandler((Handler)aclHandler);
        }
        this.xfire.getServiceRegistry().register(publicService);
        File dapConfigFile = this.config.getFileValue("dynamicAttributesConfig", false);
        DAPConfiguration dapConfiguration = new DAPConfiguration(dapConfigFile, storage.getPoolStorage(), this.executor);
        Service dapPublicService = serviceFactory.create(IDynamicAttributesPublic.class, "XUUDBDynamicAttributesQuery", null, null);
        this.dapPublicImpl = new DAPPublicImpl(dapConfiguration);
        dapPublicService.setInvoker((Invoker)new BeanInvoker((Object)this.dapPublicImpl));
        if (this.config.getBooleanValue("protectAll").booleanValue()) {
            dapPublicService.addInHandler((Handler)aclHandler);
        }
        this.xfire.getServiceRegistry().register(dapPublicService);
        Service dapAdminService = serviceFactory.create(IDAPAdmin.class, "XUUDBDAPAdmin", null, null);
        this.dapAdminImpl = new DAPAdminImpl(storage.getPoolStorage(), dapConfiguration);
        dapAdminService.setInvoker((Invoker)new BeanInvoker((Object)this.dapAdminImpl));
        dapAdminService.addInHandler((Handler)aclHandler);
        this.xfire.getServiceRegistry().register(dapAdminService);
        HttpServerProperties jettyProperties = new HttpServerProperties(this.config.getProperties(), "xuudb.httpServer.");
        String address = this.config.getValue("address");
        URL serverUrl = new URL(address);
        AuthnAndTrustProperties secProperties = null;
        if (serverUrl.getProtocol().equals("https")) {
            logger.info((Object)"Setting up Jetty server in SSL mode.");
            secProperties = new AuthnAndTrustProperties(this.config.getProperties(), "xuudb.truststore.", "xuudb.credential.");
        } else {
            logger.info((Object)"Setting up Jetty server in non-SSL mode.");
        }
        this.server = new JettyServer(serverUrl, secProperties, jettyProperties);
        this.server.start();
        hook.register(this);
    }

    @Override
    public void shutdown() throws Exception {
        this.server.stop();
    }

    @Override
    public String getNameOfService() {
        return "XUUDB Server";
    }

    public IAdmin getAdminImpl() {
        return this.adminImpl;
    }

    public IDAPAdmin getDapAdminImpl() {
        return this.dapAdminImpl;
    }

    public IPublic getPublicImpl() {
        return this.publicImpl;
    }

    public IDynamicAttributesPublic getDapPublicImpl() {
        return this.dapPublicImpl;
    }
}

