/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server;

import de.fzJuelich.unicore.xuudb.FindMappingRequestDocument;
import de.fzJuelich.unicore.xuudb.FindMappingRequestType;
import de.fzJuelich.unicore.xuudb.FindMappingResponseDocument;
import de.fzJuelich.unicore.xuudb.FindReverseMappingRequestDocument;
import de.fzJuelich.unicore.xuudb.FindReverseMappingResponseDocument;
import de.fzJuelich.unicore.xuudb.FreezeMappingRequestDocument;
import de.fzJuelich.unicore.xuudb.FreezeRemoveMappingRequestType;
import de.fzJuelich.unicore.xuudb.ListMappingRequestDocument;
import de.fzJuelich.unicore.xuudb.ListMappingRequestType;
import de.fzJuelich.unicore.xuudb.ListMappingResponseDocument;
import de.fzJuelich.unicore.xuudb.ListPoolsResponseDocument;
import de.fzJuelich.unicore.xuudb.ListPoolsResponseType;
import de.fzJuelich.unicore.xuudb.MappingDataType;
import de.fzJuelich.unicore.xuudb.MappingListDataType;
import de.fzJuelich.unicore.xuudb.PoolInfoType;
import de.fzJuelich.unicore.xuudb.RemoveMappingRequestDocument;
import de.fzJuelich.unicore.xuudb.RemovePoolRequestDocument;
import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.interfaces.IDAPAdmin;
import de.fzj.unicore.xuudb.server.DAPPublicImpl;
import de.fzj.unicore.xuudb.server.db.IPoolStorage;
import de.fzj.unicore.xuudb.server.db.MappingBean;
import de.fzj.unicore.xuudb.server.db.PoolInfoBean;
import de.fzj.unicore.xuudb.server.dynamic.DAPConfiguration;
import de.fzj.unicore.xuudb.server.dynamic.MappingStatus;
import de.fzj.unicore.xuudb.server.dynamic.Pool;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;

public class DAPAdminImpl
implements IDAPAdmin {
    private static final Logger log = Log.getLogger((String)"unicore.xuudb.server", DAPPublicImpl.class);
    private IPoolStorage backend;
    private DAPConfiguration configuration;

    public DAPAdminImpl(IPoolStorage backend, DAPConfiguration configuration) throws IOException, XmlException, ParseException {
        this.backend = backend;
        this.configuration = configuration;
    }

    public ListMappingResponseDocument listMappings(ListMappingRequestDocument xml) {
        MappingStatus status;
        ListMappingRequestType request = xml.getListMappingRequest();
        String poolName = request.getPoolId();
        String mappingType = request.getMappingType();
        log.debug((Object)("listMappings invoked for pool: " + poolName + " type: " + mappingType));
        try {
            status = MappingStatus.valueOf(mappingType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Mapping status '" + mappingType + "' is invalid, " + "can have only those values: " + Arrays.toString((Object[])MappingStatus.values()));
        }
        Integer poolId = this.getPoolId(poolName);
        List<MappingBean> mappings = this.backend.listMappings(poolId, status);
        ListMappingResponseDocument retDoc = ListMappingResponseDocument.Factory.newInstance();
        this.convertToListResponse(mappings, retDoc.addNewListMappingResponse());
        return retDoc;
    }

    public FindMappingResponseDocument findMapping(FindMappingRequestDocument xml) {
        FindMappingRequestType req = xml.getFindMappingRequest();
        log.debug((Object)("findMapping invoked for type: " + req.getType() + " value: " + req.getValue()));
        List<MappingBean> mappings = this.backend.listMappingsByValue(req.getType(), req.getValue());
        FindMappingResponseDocument retDoc = FindMappingResponseDocument.Factory.newInstance();
        this.convertToListResponse(mappings, retDoc.addNewFindMappingResponse());
        return retDoc;
    }

    public FindReverseMappingResponseDocument findReverseMapping(FindReverseMappingRequestDocument xml) {
        FindMappingRequestType req = xml.getFindReverseMappingRequest();
        log.debug((Object)("findReverseMapping invoked for type: " + req.getType() + " value: " + req.getValue()));
        List<MappingBean> mappings = this.backend.listMappingsByKey(req.getType(), req.getValue());
        FindReverseMappingResponseDocument retDoc = FindReverseMappingResponseDocument.Factory.newInstance();
        this.convertToListResponse(mappings, retDoc.addNewFindReverseMappingResponse());
        return retDoc;
    }

    public void freezeMapping(FreezeMappingRequestDocument xml) {
        FreezeRemoveMappingRequestType req = xml.getFreezeMappingRequest();
        Calendar older = req.getDate();
        String id = req.getId();
        String poolName = req.getPoolId();
        log.debug((Object)("freezeMapping invoked for id: " + id + " pool: " + poolName + " older: " + older));
        if (older != null && id != null) {
            throw new IllegalArgumentException("Ambiguous arguments: either time or mapping id can be specified");
        }
        Pool pool = this.getPool(poolName);
        if (pool == null) {
            throw new IllegalArgumentException("Pool must be specified");
        }
        if (older != null) {
            this.backend.freezeInactive(pool, new Date(older.getTimeInMillis()));
        } else {
            this.backend.freezeSpecified(pool, id);
        }
    }

    public void removeFrozenMapping(RemoveMappingRequestDocument xml) {
        FreezeRemoveMappingRequestType req = xml.getRemoveMappingRequest();
        Calendar older = req.getDate();
        String id = req.getId();
        String poolName = req.getPoolId();
        log.debug((Object)("removeFrozenMapping invoked for id: " + id + " pool: " + poolName + " older: " + older));
        if (older != null && id != null) {
            throw new IllegalArgumentException("Ambiguous arguments: either time or mapping id can be specified");
        }
        Pool pool = this.getPool(poolName);
        if (pool == null) {
            throw new IllegalArgumentException("Pool must be specified");
        }
        if (older != null) {
            this.backend.deleteOld(pool, new Date(older.getTimeInMillis()));
        } else {
            this.backend.deleteSpecified(pool, id);
        }
    }

    public void removePool(RemovePoolRequestDocument xml) {
        String poolName = xml.getRemovePoolRequest().getPoolId();
        log.debug((Object)("removePool invoked for pool: " + poolName));
        if (this.getPool(poolName) != null) {
            throw new IllegalArgumentException("The pool is not disabled in configuraiton. It must be removed from configuration first.");
        }
        this.backend.removePool(poolName);
    }

    public ListPoolsResponseDocument listPools() {
        ListPoolsResponseDocument respDoc = ListPoolsResponseDocument.Factory.newInstance();
        ListPoolsResponseType resp = respDoc.addNewListPoolsResponse();
        log.debug((Object)"listPools invoked");
        List<PoolInfoBean> pools = this.backend.listPools();
        for (PoolInfoBean bean : pools) {
            PoolInfoType xml = resp.addNewPool();
            xml.setActiveMappings(bean.getAliveMappings());
            xml.setFreeSlots(bean.getFreeSlots());
            xml.setFrozenMappings(bean.getFrozenMappings());
            xml.setPoolId(bean.getPoolName());
            xml.setPoolKeyType(bean.getPoolKeyType());
            xml.setPoolType(bean.getPoolType());
        }
        return respDoc;
    }

    private Pool getPool(String poolName) {
        if (poolName != null) {
            Pool pool = this.configuration.getPools().get(poolName);
            if (pool == null) {
                throw new IllegalArgumentException("Pool " + poolName + " is not known");
            }
            return pool;
        }
        return null;
    }

    private Integer getPoolId(String poolName) {
        Pool p = this.getPool(poolName);
        if (p != null) {
            return p.getDbKey();
        }
        return null;
    }

    private void convertToListResponse(List<MappingBean> mappings, MappingListDataType ret) {
        for (MappingBean mapping : mappings) {
            MappingDataType xmlMapping = ret.addNewMapping();
            xmlMapping.setId(mapping.getId() + "");
            xmlMapping.setKey(mapping.getMappingKey());
            xmlMapping.setValue(mapping.getEntry());
            Calendar c = Calendar.getInstance();
            c.setTime(mapping.getLastAccess());
            xmlMapping.setLastAccess(c);
            if (mapping.getFreezeTime() != null) {
                Calendar c2 = Calendar.getInstance();
                c2.setTime(mapping.getFreezeTime());
                xmlMapping.setFreezeTime(c2);
            }
            xmlMapping.setPoolName(mapping.getPoolName());
            xmlMapping.setKeyType(mapping.getMappingKeyType());
        }
    }
}

