/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server;

import de.fzJuelich.unicore.xuudb.AddCertificateDocument;
import de.fzJuelich.unicore.xuudb.AddCertificateResponseDocument;
import de.fzJuelich.unicore.xuudb.DatabaseType;
import de.fzJuelich.unicore.xuudb.ImportDatabaseDocument;
import de.fzJuelich.unicore.xuudb.ImportDatabaseResponseDocument;
import de.fzJuelich.unicore.xuudb.ListDatabaseDocument;
import de.fzJuelich.unicore.xuudb.ListDatabaseResponseDocument;
import de.fzJuelich.unicore.xuudb.LoginDataType;
import de.fzJuelich.unicore.xuudb.RemoveCertificateDocument;
import de.fzJuelich.unicore.xuudb.RemoveCertificateResponseDocument;
import de.fzJuelich.unicore.xuudb.UpdateCertificateDocument;
import de.fzJuelich.unicore.xuudb.UpdateCertificateResponseDocument;
import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.interfaces.IAdmin;
import de.fzj.unicore.xuudb.server.ServerConfiguration;
import de.fzj.unicore.xuudb.server.db.IClassicStorage;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.log4j.Logger;

public class AdminImpl
implements IAdmin {
    private static final Logger log = Log.getLogger((String)"unicore.xuudb.server", AdminImpl.class);
    private IClassicStorage xuudb;
    private ServerConfiguration config;
    private boolean isDNMode;
    private String version;

    public AdminImpl(ServerConfiguration co, IClassicStorage backend) throws Exception {
        this.config = co;
        this.xuudb = backend;
        String dbtype = this.config.getValue("type");
        this.isDNMode = "dn".equalsIgnoreCase(dbtype);
        this.version = this.getClass().getPackage().getImplementationVersion();
        if (this.version == null) {
            this.version = "DEVELOPMENT";
        }
    }

    public AddCertificateResponseDocument addCertificate(AddCertificateDocument xml) {
        AddCertificateResponseDocument ret = AddCertificateResponseDocument.Factory.newInstance();
        try {
            String ans = this.xuudb.add(xml.getAddCertificate());
            ret.setAddCertificateResponse(ans);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Got wrong/unparsable argument: " + xml.xmlText() + "\nError is: " + e.toString()));
            throw e;
        }
        catch (PersistenceException e) {
            Log.logException((String)"Error in database code", (Throwable)e, (Logger)log);
            String msg = Log.createFaultMessage((String)"Internal server error, database related", (Throwable)e);
            throw new RuntimeException(msg);
        }
        return ret;
    }

    public ListDatabaseResponseDocument listDatabase(ListDatabaseDocument xml) {
        ListDatabaseResponseDocument ret = ListDatabaseResponseDocument.Factory.newInstance();
        LoginDataType[] ans = null;
        try {
            ans = this.xuudb.listDB(xml.getListDatabase());
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Got wrong/unparsable argument: " + xml.xmlText() + "\nError is: " + e.toString()));
            throw e;
        }
        catch (PersistenceException e) {
            Log.logException((String)"Error in database code", (Throwable)e, (Logger)log);
            String msg = Log.createFaultMessage((String)"Internal server error, database related", (Throwable)e);
            throw new RuntimeException(msg);
        }
        DatabaseType data = DatabaseType.Factory.newInstance();
        data.setDatabaseArray(ans);
        data.setXUUDBInfo(this.getInfo());
        data.setIsDNMode(this.isDNMode);
        ret.setListDatabaseResponse(data);
        return ret;
    }

    public RemoveCertificateResponseDocument removeCertificate(RemoveCertificateDocument xml) {
        RemoveCertificateResponseDocument ret = RemoveCertificateResponseDocument.Factory.newInstance();
        String ans = null;
        try {
            ans = this.xuudb.remove(xml.getRemoveCertificate());
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Got wrong/unparsable argument: " + xml.xmlText() + "\nError is: " + e.toString()));
            throw e;
        }
        catch (PersistenceException e) {
            Log.logException((String)"Error in database code", (Throwable)e, (Logger)log);
            String msg = Log.createFaultMessage((String)"Internal server error, database related", (Throwable)e);
            throw new RuntimeException(msg);
        }
        ret.setRemoveCertificateResponse(ans);
        return ret;
    }

    public UpdateCertificateResponseDocument updateCertificate(UpdateCertificateDocument xml) {
        String gcid = xml.getUpdateCertificate().getGcID();
        String token = xml.getUpdateCertificate().getToken();
        UpdateCertificateResponseDocument ret = UpdateCertificateResponseDocument.Factory.newInstance();
        try {
            String ans = this.xuudb.update(gcid, token, xml.getUpdateCertificate().getData());
            ret.setUpdateCertificateResponse(ans);
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Got wrong/unparsable argument: " + xml.xmlText() + "\nError is: " + e.toString()));
            throw e;
        }
        catch (PersistenceException e) {
            Log.logException((String)"Error in database code", (Throwable)e, (Logger)log);
            String msg = Log.createFaultMessage((String)"Internal server error, database related", (Throwable)e);
            throw new RuntimeException(msg);
        }
        return ret;
    }

    public ImportDatabaseResponseDocument importDatabase(ImportDatabaseDocument xml) {
        try {
            String erg = this.xuudb.import_csv(xml);
            ImportDatabaseResponseDocument ret = ImportDatabaseResponseDocument.Factory.newInstance();
            ret.setImportDatabaseResponse(erg);
            return ret;
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Got wrong/unparsable argument: " + xml.xmlText() + "\nError is: " + e.toString()));
            throw e;
        }
        catch (PersistenceException e) {
            Log.logException((String)"Error in database code", (Throwable)e, (Logger)log);
            String msg = Log.createFaultMessage((String)"Internal server error, database related", (Throwable)e);
            throw new RuntimeException(msg);
        }
    }

    protected String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("XUUDB Server version ").append(this.version);
        sb.append(" ").append("running in ").append(this.isDNMode ? "DN" : "normal").append(" mode");
        return sb.toString();
    }
}

