/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.server;

import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.server.FileWatcher;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.transport.http.XFireServletController;

public class ACLHandler
extends AbstractHandler {
    private static final Logger logger = Log.getLogger((String)"unicore.xuudb.server", ACLHandler.class);
    private final File aclFile;
    private final FileWatcher watchDog;
    private final boolean active;
    private final Set<String> acceptedDNs = new HashSet<String>();

    public ACLHandler(ScheduledExecutorService executor) throws IOException {
        this(new File("conf", "xuudb.acl"), executor);
    }

    public ACLHandler(File aclFile, ScheduledExecutorService executor) throws IOException {
        this.aclFile = aclFile;
        if (!aclFile.exists()) {
            logger.warn((Object)("ACL not active: file <" + aclFile + "> does not exist"));
            this.active = false;
            this.watchDog = null;
            return;
        }
        this.active = true;
        logger.info((Object)("XUUDB using ACL file " + aclFile));
        this.readACL();
        this.watchDog = new FileWatcher(aclFile, new Runnable(){

            @Override
            public void run() {
                ACLHandler.this.readACL();
            }
        });
        executor.schedule(this.watchDog, 3000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readACL() {
        Set<String> set = this.acceptedDNs;
        synchronized (set) {
            BufferedReader br = null;
            try {
                String theLine;
                br = new BufferedReader(new FileReader(this.aclFile));
                this.acceptedDNs.clear();
                while ((theLine = br.readLine()) != null) {
                    String line = theLine.trim();
                    if (line.startsWith("#") || line.trim().equals("")) continue;
                    try {
                        String canonical = X500NameUtils.getComparableForm((String)line);
                        this.acceptedDNs.add(canonical);
                        logger.info((Object)("Allowing admin access for <" + line + ">"));
                    }
                    catch (Exception ex) {
                        logger.warn((Object)("Invalid entry <" + line + ">"), (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                logger.fatal((Object)"ACL file read error!", (Throwable)ex);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void invoke(MessageContext context) throws Exception {
        String userName = "anonymous";
        try {
            X509Certificate[] certPath = (X509Certificate[])XFireServletController.getRequest().getAttribute("javax.servlet.request.X509Certificate");
            if (certPath != null) {
                X509Certificate userCert = certPath[0];
                userName = userCert.getSubjectX500Principal().getName();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Can't get user name from request. No ssl?", (Throwable)ex);
        }
        logger.info((Object)("Admin access from " + userName));
        if (!this.active) {
            return;
        }
        this.checkAccess(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAccess(String userName) throws Exception {
        Set<String> set = this.acceptedDNs;
        synchronized (set) {
            if (!this.acceptedDNs.contains(X500NameUtils.getComparableForm((String)userName))) {
                String msg = "Admin access denied!\n\nTo allow access for this certificate, the distinuguished name \n\"" + userName + "\nneeds to be entered into the ACL file." + "\nPlease check the XUUDB's ACL file!\n\n";
                throw new Exception(msg);
            }
        }
    }
}

