/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.proto;

import eu.unicore.samly2.SAMLUtils;
import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.proto.AbstractSAMLMessage;
import eu.unicore.security.dsig.DSigException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import org.w3c.dom.Document;
import xmlbeans.org.oasis.saml2.protocol.StatusCodeType;
import xmlbeans.org.oasis.saml2.protocol.StatusResponseType;
import xmlbeans.org.oasis.saml2.protocol.StatusType;

public abstract class AbstractStatusResponse
extends AbstractSAMLMessage {
    protected StatusResponseType xmlResp;

    protected AbstractStatusResponse() {
    }

    protected AbstractStatusResponse(StatusResponseType src) throws SAMLParseException {
        this.xmlResp = src;
    }

    protected void init(StatusResponseType src, NameID issuer, String inResponseTo) {
        this.xmlResp = src;
        this.xmlResp.setIssuer(issuer.getXBean());
        this.xmlResp.setIssueInstant(Calendar.getInstance());
        this.xmlResp.setID(this.genID());
        this.xmlResp.setVersion("2.0");
        if (inResponseTo != null) {
            this.xmlResp.setInResponseTo(inResponseTo);
        }
    }

    public void parse() throws SAMLParseException {
        if (this.xmlResp.getVersion() == null) {
            throw new SAMLParseException("No SAML version is set");
        }
        String ver = this.xmlResp.getVersion();
        if (!ver.equals("2.0")) {
            throw new SAMLParseException("Only SAML 2.0 version is supported");
        }
        if (this.xmlResp.getID() == null) {
            throw new SAMLParseException("No ID is set");
        }
        if (this.xmlResp.getIssueInstant() == null) {
            throw new SAMLParseException("No IssueInstant is set");
        }
        if (this.xmlResp.getStatus() == null) {
            throw new SAMLParseException("No Status is set");
        }
    }

    protected StatusType getOKStatus() {
        StatusType ok = StatusType.Factory.newInstance();
        StatusCodeType okCode = ok.addNewStatusCode();
        okCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        return ok;
    }

    protected StatusType getErrorStatus(SAMLProtocolException e) {
        StatusType error = StatusType.Factory.newInstance();
        StatusCodeType errorCode = error.addNewStatusCode();
        errorCode.setValue(e.getCode());
        if (e.getSubCode() != null) {
            errorCode.addNewStatusCode().setValue(e.getSubCode());
        }
        if (e.getMessage() != null) {
            error.setStatusMessage(e.getMessage());
        }
        return error;
    }

    @Override
    public boolean isSigned() {
        return this.xmlResp.getSignature() != null && !this.xmlResp.getSignature().isNil();
    }

    @Override
    public Document getDOM() throws DSigException {
        return SAMLUtils.getDOM(this.getDoc());
    }

    @Override
    public X509Certificate[] getIssuerFromSignature() {
        return SAMLUtils.getIssuerFromSignature(this.xmlResp.getSignature());
    }

    public boolean isStatusOK() {
        StatusType status = this.xmlResp.getStatus();
        if (status == null || status.getStatusCode() == null) {
            return false;
        }
        return status.getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success");
    }

    public String getErrorStatus() {
        StatusType status = this.xmlResp.getStatus();
        if (status == null || status.getStatusCode() == null) {
            return null;
        }
        return status.getStatusCode().getValue();
    }

    public String getSubErrorStatus() {
        StatusType status = this.xmlResp.getStatus();
        if (status == null || status.getStatusCode() == null || status.getStatusCode().getStatusCode() == null) {
            return null;
        }
        return status.getStatusCode().getStatusCode().getValue();
    }

    public String getErrorMessage() {
        StatusType status = this.xmlResp.getStatus();
        if (status == null || status.getStatusCode() == null) {
            return null;
        }
        return status.getStatusMessage();
    }
}

