/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.etd;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.samly2.exceptions.SAMLParseException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AttributeStatementType;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;

public class TrustDelegation
extends Assertion {
    private static final long serialVersionUID = 1L;
    public static final String CUSTODIAN_NAME = "TrustDelegationOfUser";
    public static final String CUSTODIAN_NAME_FORMAT_DN = "urn:unicore:trust-delegation:dn";
    public static final String CUSTODIAN_NAME_FORMAT_FP = "urn:unicore:trust-delegation:hashcode";
    private String custodianDN;
    private Integer hash;

    public TrustDelegation(String custodian) {
        String dn;
        this.custodianDN = dn = X500NameUtils.getPortableRFC2253Form((String)custodian);
        this.hash = null;
        SAMLAttribute custodianA = new SAMLAttribute(CUSTODIAN_NAME, CUSTODIAN_NAME_FORMAT_DN);
        custodianA.addStringAttributeValue(dn);
        this.addAttribute(custodianA);
    }

    public TrustDelegation(X509Certificate custodian) {
        String dn;
        this.custodianDN = dn = custodian.getSubjectX500Principal().getName();
        SAMLAttribute custodianA = new SAMLAttribute(CUSTODIAN_NAME, CUSTODIAN_NAME_FORMAT_DN);
        custodianA.addStringAttributeValue(dn);
        this.addAttribute(custodianA);
        this.hash = custodian.hashCode();
        SAMLAttribute custodian2A = new SAMLAttribute(CUSTODIAN_NAME, CUSTODIAN_NAME_FORMAT_FP);
        custodian2A.addStringAttributeValue(this.hash + "");
        this.addAttribute(custodian2A);
    }

    public TrustDelegation(AssertionDocument doc) throws SAMLParseException, XmlException, IOException {
        super(doc);
        if (this.getSubjectDN() == null) {
            throw new SAMLParseException("No subject (user) in assertion.");
        }
        AttributeStatementType[] attrSs = this.getAttributes();
        this.custodianDN = null;
        if (attrSs == null) {
            throw new SAMLParseException("No attribute statement in SAML assertion");
        }
        for (int i = 0; i < attrSs.length; ++i) {
            AttributeType[] attrs = attrSs[i].getAttributeArray();
            for (int j = 0; j < attrs.length; ++j) {
                XmlCursor cur;
                if (!attrs[j].getName().equals(CUSTODIAN_NAME)) continue;
                if (attrs[j].getNameFormat().equals(CUSTODIAN_NAME_FORMAT_DN)) {
                    cur = attrs[j].getAttributeValueArray(0).newCursor();
                    cur.toFirstContentToken();
                    this.custodianDN = cur.getTextValue();
                    continue;
                }
                if (!attrs[j].getNameFormat().equals(CUSTODIAN_NAME_FORMAT_FP)) continue;
                cur = attrs[j].getAttributeValueArray(0).newCursor();
                cur.toFirstContentToken();
                try {
                    this.hash = Integer.parseInt(cur.getTextValue());
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SAMLParseException("Custodian certificate hash value is not an integer");
                }
            }
        }
        if (this.custodianDN == null) {
            throw new SAMLParseException("SAML assertion doesn't contain trust delegation attribute");
        }
    }

    public String getCustodianDN() {
        return this.custodianDN;
    }

    public Integer getCustodianCertHash() {
        return this.hash;
    }
}

