/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.client.actions;

import de.fzJuelich.unicore.xuudb.LoginDataType;
import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.X509Utils;
import de.fzj.unicore.xuudb.client.actions.AbstractAction;
import de.fzj.unicore.xuudb.client.actions.ConnectionManager;
import de.fzj.unicore.xuudb.client.wsapi.XUUDBResponse;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class UpdateAction
extends AbstractAction {
    private static final Logger logger = Log.getLogger((String)"unicore.xuudb.client", UpdateAction.class);

    public UpdateAction(ConnectionManager cm) {
        super(cm, "update", "Update entry in database.\n Syntax:\n        update <gcID> <pemfile or DN> gcID=x|pemfile=file|dn=\"dn\"|role=x|xlogin=x|project=x\n Example:\n        update DEMO-SITE certs/demouser.pem xlogin=jb007", 3, 8);
    }

    @Override
    public boolean invoke(String[] args, boolean isBatch) throws Exception {
        logger.debug((Object)"Command: update ");
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                logger.debug((Object)("Parameter " + i + ": " + args[i]));
            }
        }
        String[] lastArgs = new String[args.length - 2];
        for (int i = 2; i < args.length; ++i) {
            lastArgs[i - 2] = args[i];
        }
        String token = null;
        try {
            logger.debug((Object)"Trying to read token as a DN...");
            token = X500NameUtils.getPortableRFC2253Form((String)args[1]);
        }
        catch (Exception e) {
            logger.debug((Object)"Token is not a DN.");
            try {
                logger.debug((Object)"Trying to read token from file (x509)...");
                token = X509Utils.getStringFromPEMFile(args[1]);
            }
            catch (IOException e1) {
                String msg = "Can't read pem from file";
                logger.error((Object)msg, (Throwable)e1);
                throw new Exception(msg, e1);
            }
        }
        LoginDataType data = null;
        try {
            logger.debug((Object)"Building Ulogin for db update");
            data = this.parseArgsToUlogin(lastArgs);
        }
        catch (FileNotFoundException e) {
            String msg = "Can't build query (check pem file path?)";
            logger.error((Object)msg, (Throwable)e);
            throw new FileNotFoundException(msg);
        }
        catch (Exception e) {
            String msg = "Can't build query (check parameters?)";
            logger.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        XUUDBResponse resp = this.cm.admin.update(args[0], token, data);
        System.out.println("Done. Received: " + resp.getStatus());
        return true;
    }
}

