/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.client.actions;

import de.fzJuelich.unicore.xuudb.LoginDataType;
import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.client.actions.AbstractAction;
import de.fzj.unicore.xuudb.client.actions.ConnectionManager;
import de.fzj.unicore.xuudb.client.wsapi.XUUDBResponse;
import java.io.FileNotFoundException;
import org.apache.log4j.Logger;

public class RemoveAction
extends AbstractAction {
    private static final Logger logger = Log.getLogger((String)"unicore.xuudb.client", RemoveAction.class);

    public RemoveAction(ConnectionManager cm) {
        super(cm, "remove", "Remove entry from database.\n Syntax:\n        remove ALL|gcID=x|pemfile=file|dn='DN'|role=x|xlogin=x|project=x\n Example:\n        remove xlogin=jdoe", 1, 6);
    }

    @Override
    public boolean invoke(String[] args, boolean isBatch) throws Exception {
        LoginDataType data;
        logger.debug((Object)"Command: remove ");
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                logger.debug((Object)("Parameter " + i + ": " + args[i]));
            }
        }
        if (args[0].equalsIgnoreCase("ALL")) {
            logger.debug((Object)"Clearing complete database.");
            String msg = "All entries will be removed!";
            if (!isBatch && !this.confirm(msg)) {
                logger.debug((Object)"Operation stopped by user");
                System.out.println("Database was not changed.");
                return true;
            }
            data = LoginDataType.Factory.newInstance();
        } else {
            try {
                logger.debug((Object)"Building Ulogin for db query");
                data = this.parseArgsToUlogin(args);
            }
            catch (FileNotFoundException e) {
                String msg = "Can't build query (check pem file path?";
                logger.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
            catch (Exception e) {
                String msg = "Can't build query (check parameters?)";
                logger.error((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
        }
        XUUDBResponse resp = this.cm.admin.remove(data);
        System.out.println("Done. Received: " + resp.getStatus());
        return true;
    }
}

