/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.client.actions;

import de.fzJuelich.unicore.xuudb.LoginDataType;
import de.fzj.unicore.xuudb.Log;
import de.fzj.unicore.xuudb.client.actions.AbstractAction;
import de.fzj.unicore.xuudb.client.actions.ConnectionManager;
import de.fzj.unicore.xuudb.client.wsapi.XUUDBResponse;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ImportAction
extends AbstractAction {
    private static final Logger logger = Log.getLogger((String)"unicore.xuudb.client", ImportAction.class);

    public ImportAction(ConnectionManager cm) {
        super(cm, "import", "Import entries from csv file to database.\n Syntax:\n        import <csv-file> [clearDB]\n Example:\n        import uudb.csv", 1, 2);
    }

    @Override
    public boolean invoke(String[] args, boolean isBatch) throws Exception {
        File incsv;
        logger.debug((Object)"Command: import ");
        for (int i = 0; i < args.length; ++i) {
            logger.debug((Object)("Parameter " + i + ": " + args[i]));
        }
        boolean clear = false;
        if (args.length > 1) {
            clear = "clearDB".equalsIgnoreCase(args[1]);
        }
        if (!(incsv = new File(args[0])).exists()) {
            String msg = "File does not exist: " + incsv.getAbsolutePath();
            logger.error((Object)msg);
            throw new IOException(msg, null);
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(incsv)));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
            throw new FileNotFoundException("Error opening: " + incsv.getAbsolutePath());
        }
        ArrayList<LoginDataType> data = new ArrayList<LoginDataType>();
        br.readLine();
        String line = null;
        int linec = 0;
        while ((line = br.readLine()) != null) {
            ++linec;
            LoginDataType login = LoginDataType.Factory.newInstance();
            String[] tokens = line.split(";");
            if (tokens.length == 6) {
                login.setGcID(tokens[1]);
                login.setXlogin(tokens[2]);
                login.setRole(tokens[3]);
                login.setProjects(tokens[4]);
                login.setToken(X500NameUtils.getPortableRFC2253Form((String)tokens[5]));
                data.add(login);
                continue;
            }
            logger.warn((Object)("  >> Action: Ignoring line " + linec + ".  Count of token is not 6"));
        }
        LoginDataType[] dd = new LoginDataType[data.size()];
        data.toArray(dd);
        XUUDBResponse resp = this.cm.admin.importCsv(dd, clear);
        System.out.println("Done. Received: " + resp.getStatus());
        return true;
    }
}

