/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb.client.actions;

import de.fzJuelich.unicore.xuudb.LoginDataType;
import de.fzJuelich.unicore.xuudb.MappingDataType;
import de.fzj.unicore.xuudb.X509Utils;
import de.fzj.unicore.xuudb.client.actions.ConnectionManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.DateFormat;

public abstract class AbstractAction
implements Comparable<AbstractAction> {
    private static final DateFormat SHORT = DateFormat.getDateTimeInstance(3, 2);
    protected String cmd;
    protected String category;
    protected String[] aliases;
    protected String help;
    protected int minArgs;
    protected int maxArgs;
    protected ConnectionManager cm;

    protected AbstractAction(ConnectionManager cm, String cmd, String help) {
        this.cm = cm;
        this.cmd = cmd;
        this.help = help;
        this.minArgs = 0;
        this.maxArgs = 100;
        this.aliases = new String[0];
        this.category = Category.classic.toString();
    }

    protected AbstractAction(ConnectionManager cm, String cmd, String help, int minArgs) {
        this(cm, cmd, help);
        this.minArgs = minArgs;
    }

    protected AbstractAction(ConnectionManager cm, String cmd, String help, int minArgs, int maxArgs) {
        this(cm, cmd, help);
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
    }

    protected AbstractAction(ConnectionManager cm, String cmd, String help, int minArgs, int maxArgs, String alias) {
        this(cm, cmd, help, minArgs, maxArgs);
        this.aliases = new String[]{alias};
    }

    public String getName() {
        return this.cmd;
    }

    public String getHelp() {
        return this.help;
    }

    public int getMinArgsNumber() {
        return this.minArgs;
    }

    public int getMaxArgsNumber() {
        return this.maxArgs;
    }

    @Override
    public int compareTo(AbstractAction a) {
        int c = a.getCategory().compareTo(this.getCategory());
        if (c == 0) {
            return a.getName().compareTo(this.cmd);
        }
        return c;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public abstract boolean invoke(String[] var1, boolean var2) throws Exception;

    protected LoginDataType parseArgsToUlogin(String[] args) throws Exception {
        LoginDataType ret = LoginDataType.Factory.newInstance();
        boolean alreadyHaveToken = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].toLowerCase().startsWith("gcid=")) {
                ret.setGcID(args[i].substring(5));
                continue;
            }
            if (args[i].toLowerCase().startsWith("xlogin=")) {
                ret.setXlogin(args[i].substring(7));
                continue;
            }
            if (args[i].toLowerCase().startsWith("pemfile=")) {
                String pem = args[i].substring(8);
                ret.setToken(X509Utils.getStringFromPEMFile(pem));
                alreadyHaveToken = true;
                continue;
            }
            if (args[i].toLowerCase().startsWith("dn=")) {
                if (alreadyHaveToken) {
                    throw new Exception("You can not use pemfile= and dn= at a time.");
                }
                ret.setToken(args[i].substring(3));
                continue;
            }
            if (args[i].toLowerCase().startsWith("role=")) {
                ret.setRole(args[i].substring(5));
                continue;
            }
            if (args[i].toLowerCase().startsWith("project=")) {
                ret.setProjects(args[i].substring(8));
                continue;
            }
            throw new Exception("Unknown parameter: " + args[i]);
        }
        return ret;
    }

    protected boolean confirm(String message) {
        System.out.println(message + "\nAre you sure? [yes, no]");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String ans = "no";
        try {
            ans = br.readLine();
        }
        catch (Exception e) {
            // empty catch block
        }
        return "yes".equalsIgnoreCase(ans);
    }

    protected void printMapping(MappingDataType[] resp) {
        if (resp == null) {
            System.out.println("The database query result is empty.");
        }
        if (resp.length == 0) {
            System.out.println("The database query result is empty.");
        } else {
            System.out.println("The database query result contains   " + resp.length + "   entries:");
            System.out.printf("%-5s|%-25s|%-10s|%-20s|%-30s|%-18s|%-18s|\n", "  Id", "         Key", " Key type", "       Value", "          Pool name", "    Freeze time", "   Last Access");
            System.out.println("-------------------------------------------------------------------------------------------------------------------------------------");
            for (int i = 0; i < resp.length; ++i) {
                String freeze = resp[i].getFreezeTime() != null ? SHORT.format(resp[i].getFreezeTime().getTime()) : "";
                String last = resp[i].getLastAccess() != null ? SHORT.format(resp[i].getLastAccess().getTime()) : "";
                System.out.printf("%5s|%25s|%10s|%20s|%30s|%18s|%18s|\n", resp[i].getId(), resp[i].getKey(), resp[i].getKeyType(), resp[i].getValue(), resp[i].getPoolName(), freeze, last);
            }
        }
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    protected static enum Category {
        classic,
        dynamic,
        other;

    }
}

